/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core;

import com.ibm.cdz.common.extnpt.api.IDiagnosticObject;
import com.ibm.cdz.common.extnpt.api.IGeneralObject;
import com.ibm.cdz.common.extnpt.api.IListingObject;
import com.ibm.cdz.common.extnpt.api.IRemoteCompileObject;
import com.ibm.ftt.cdz.core.CDZSupportPlugin;
import com.ibm.ftt.cdz.core.persistence.PersistenceUtil;
import com.ibm.ftt.projects.core.emf.logicalfactory.LogicalResourceFactory;
import com.ibm.ftt.projects.core.impl.logical.LogicalPropertyManager;
import com.ibm.ftt.projects.core.logical.ILogicalContainer;
import com.ibm.ftt.projects.core.logical.ILogicalFile;
import com.ibm.ftt.projects.core.logical.ILogicalPropertyManager;
import com.ibm.ftt.projects.core.logical.ILogicalResource;
import com.ibm.ftt.projects.zos.ZOSProjectsResources;
import com.ibm.ftt.projects.zos.zoslogical.LZOSDataSetMember;
import com.ibm.ftt.projects.zos.zoslogical.LZOSPartitionedDataSet;
import com.ibm.ftt.projects.zos.zoslogical.LZOSProject;
import com.ibm.ftt.projects.zos.zoslogical.LZOSResource;
import com.ibm.ftt.projects.zos.zoslogical.LZOSSequentialDataSet;
import com.ibm.ftt.resources.core.emf.factory.FactoryFactory;
import com.ibm.ftt.resources.core.factory.IPhysicalResourceFactory;
import com.ibm.ftt.resources.core.impl.CacheManager;
import com.ibm.ftt.resources.core.physical.IContainer;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.zosphysical.ZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.ZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.ZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMemberImpl;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSPartitionedDataSetImpl;
import com.ibm.ftt.ui.propertypages.dialogs.PBGenJCLFileNameInputDialog;
import com.ibm.ftt.ui.views.navigator.NavigatorResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class GenerateCompileJCLAction
extends Action {
    private IStructuredSelection selection;
    private String jclFileName;
    private ILogicalPropertyManager manager = LogicalPropertyManager.getManager();
    private String jobName;
    private String genDSName;
    private ZOSSystemImage systemImage;
    private ZOSDataSetMember member;
    private boolean newMember;
    private BufferedWriter bufferedWriter;
    private IProject tmpPrj = CacheManager.getProject();
    private boolean create = true;
    protected String separator = "//*";
    protected String ss = "//";
    private String jclFilePath;

    public GenerateCompileJCLAction(IStructuredSelection selection) {
        super("Generate JCL for Compile");
        this.selection = selection;
    }

    public void run() {
        boolean logical = this.inspectResources();
        if (logical) {
            this.handleLogicalResource();
        }
    }

    private boolean inspectResources() {
        Iterator iter = this.selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof LZOSResource) continue;
            return false;
        }
        return true;
    }

    private void handleLogicalResource() {
        Shell shell = CDZSupportPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        Iterator iter = this.selection.iterator();
        Vector<Object> resourceVector = new Vector<Object>();
        while (iter.hasNext()) {
            LZOSResource res = (LZOSResource)iter.next();
            if (res instanceof LZOSDataSetMember || res instanceof LZOSSequentialDataSet) {
                resourceVector.add(res);
                continue;
            }
            if (!(res instanceof LZOSPartitionedDataSet)) continue;
            IAdaptable[] members = ((LZOSPartitionedDataSet)res).members();
            int j = 0;
            while (j < members.length) {
                resourceVector.add(members[j]);
                ++j;
            }
        }
        if (resourceVector.size() > 0) {
            LZOSResource resource = (LZOSResource)resourceVector.get(0);
            if (!this.openJCLFileForGen((ILogicalResource)resource, shell)) {
                return;
            }
            if (!this.writeJobCard((ILogicalResource)resource)) {
                return;
            }
            if (!this.writeCompileStep(resourceVector)) {
                return;
            }
            if (!this.closeJCLStreamForGen((ILogicalResource)resource, shell)) {
                return;
            }
        }
    }

    private boolean writeCompileStep(Vector resourceVector) {
        int i = 0;
        while (i < resourceVector.size()) {
            LZOSResource resource = (LZOSResource)resourceVector.get(i);
            this.dumpAsIsJCL("//COMPILE" + i + "       EXEC  PGM=CCNDRVR, ", false);
            IRemoteCompileObject compileObj = PersistenceUtil.getRemoteCompileObject(resource);
            this.writeOptions(resource, compileObj);
            this.dumpAsIsJCL("//STEPLIB  DD  DSN=CEE.SCEERUN,DISP=SHR", false);
            this.dumpAsIsJCL("//         DD  DSN=CEE.SCEERUN2,DISP=SHR", false);
            this.dumpAsIsJCL("//         DD  DSN=CBC.SCCNCMP,DISP=SHR", false);
            StringBuffer sysIn = new StringBuffer();
            sysIn.append("//SYSIN DD DSNAME=");
            if (resource instanceof LZOSDataSetMember) {
                LZOSDataSetMember member = (LZOSDataSetMember)resource;
                sysIn.append(member.getLogicalParent().getName());
                sysIn.append('(');
                sysIn.append(member.getNameWithoutExtension());
                sysIn.append(')');
            } else {
                LZOSSequentialDataSet ds = (LZOSSequentialDataSet)resource;
                if (ds.getLogicalParent() != null && !(ds.getLogicalParent() instanceof LZOSProject)) {
                    sysIn.append(ds.getLogicalParent().getName());
                    sysIn.append('(');
                }
                sysIn.append(ds.getNameWithoutExtension());
                if (ds.getLogicalParent() != null && !(ds.getLogicalParent() instanceof LZOSProject)) {
                    sysIn.append(')');
                }
            }
            sysIn.append(",DISP=SHR");
            this.dumpAsIsJCL(sysIn.toString(), false);
            StringBuffer outputFile = new StringBuffer();
            outputFile.append("//SYSLIN DD DSN=");
            outputFile.append(compileObj.getGeneralObject().getOutputFilename());
            outputFile.append(",DISP=SHR");
            this.dumpAsIsJCL(outputFile.toString(), false);
            ++i;
        }
        return true;
    }

    private void writeOptions(LZOSResource resource, IRemoteCompileObject compileObj) {
        String define;
        String userIncludePath;
        StringBuffer parmString = new StringBuffer("// PARM='/");
        this.isCPPResource(resource);
        parmString.append("OPTFILE(DD:OPTION)'");
        this.dumpAsIsJCL(parmString.toString(), false);
        parmString = new StringBuffer();
        parmString.append("//OPTION DD DATA,DLM=@@\n");
        String sysIncludePath = compileObj.getGeneralObject().getSystemIncludePath();
        if (sysIncludePath != null && sysIncludePath.length() > 0) {
            parmString.append("SEARCH(");
            parmString.append(this.getSearchPath(sysIncludePath));
            parmString.append(")\n");
        }
        if ((userIncludePath = compileObj.getGeneralObject().getIncludePath()) != null && userIncludePath.length() > 0) {
            parmString.append("LSEARCH(");
            parmString.append(this.getSearchPath(userIncludePath));
            parmString.append(")\n");
        }
        if ((define = compileObj.getGeneralObject().getDEFINE()) != null && define.length() > 0) {
            parmString.append("DEFINE(");
            parmString.append(define);
            parmString.append(")\n");
        }
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isPPONLY(), "PPONLY", compileObj.getGeneralObject().getPPONLY_Filename());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isCSECT(), "CSECT", compileObj.getGeneralObject().getCSECT_Text());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isEXPORTALL(), "EXPORTALL", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isLONGNAME(), "LONGNAME", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isSTART(), "STA", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isXREF(), "XREF", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isOFFSET(), "OFFSET", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isSHOWINC(), "SHOWINC", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isEXPMAC(), "EXPMAC", null);
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isSOURCE(), "SOURCE", compileObj.getListingObject().getFilename());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isOPTIMIZE(), "OPT", compileObj.getGeneralObject().getOPTIMIZE_Level());
        this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isLIST(), "LIST", compileObj.getListingObject().getFilename());
        this.handleTESTProperty(parmString, resource, compileObj.getDiagnosticObject());
        if (this.isCPPResource(resource)) {
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isTEMPINC(), "TEMPINC", compileObj.getGeneralObject().getTEMPINC_Location());
            if (compileObj.getGeneralObject().isSEQNUMBER() && compileObj.getGeneralObject().isUseMN()) {
                parmString.append("SEQ(" + compileObj.getGeneralObject().getSEQ_M() + "," + compileObj.getGeneralObject().getSEQ_N() + ")\n");
            } else {
                this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isSEQNUMBER(), "SEQ", null);
            }
            this.handleATTRIBUTEOption(parmString, compileObj.getListingObject());
            this.handleINFOOption(parmString, compileObj.getDiagnosticObject());
            parmString.append(compileObj.getOtherObject().getCppOptions());
            parmString.append(compileObj.getOtherObject().getCOrCppOptions());
        } else {
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isSEQNUMBER(), "SEQ", String.valueOf(compileObj.getGeneralObject().getSEQ_M()) + "," + compileObj.getGeneralObject().getSEQ_N());
            this.handleDLLOption(parmString, compileObj.getGeneralObject());
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getGeneralObject().isRENT(), "RENT", null);
            this.handleBooleanPropertyWithNewLine(parmString, compileObj.getListingObject().isAGGREGATE(), "AGGREGATE", null);
            this.handleCHECKOUTOption(parmString, compileObj.getDiagnosticObject());
            parmString.append(compileObj.getOtherObject().getCOptions());
            parmString.append(compileObj.getOtherObject().getCOrCppOptions());
        }
        parmString.append("@@");
        this.dumpAsIsJCL(parmString.toString(), false);
    }

    private void handleCHECKOUTOption(StringBuffer parmString, IDiagnosticObject obj) {
        if (obj.isINFO()) {
            if (obj.isCHECKOUT_ALL()) {
                parmString.append("CHECKOUT(ALL)\n");
            } else if (obj.isCHECKOUT_NONE()) {
                parmString.append("CHECKOUT(NONE)\n");
            } else {
                parmString.append("CHECKOUT'(");
                this.handleBooleanProperty(parmString, obj.isACCURACY(), "AC,", null);
                this.handleBooleanProperty(parmString, obj.isENUM(), "EN,", null);
                this.handleBooleanProperty(parmString, obj.isEXTERN(), "EX,", null);
                this.handleBooleanProperty(parmString, obj.isGENERAL(), "GE,", null);
                this.handleBooleanProperty(parmString, obj.isGOTO(), "GO,", null);
                this.handleBooleanProperty(parmString, obj.isINIT(), "I,", null);
                this.handleBooleanProperty(parmString, obj.isPARM(), "PAR,", null);
                this.handleBooleanProperty(parmString, obj.isPORT(), "POR,", null);
                this.handleBooleanProperty(parmString, obj.isPPC(), "PPC,", null);
                this.handleBooleanProperty(parmString, obj.isPPT(), "PPT,", null);
                this.handleBooleanProperty(parmString, obj.isTRUNC(), "TRU", null);
                parmString.append(")' ");
            }
        } else {
            parmString.append("NOCHECKOUT ");
        }
    }

    private void handleDLLOption(StringBuffer parmString, IGeneralObject obj) {
        if (obj.isDLL()) {
            parmString.append("DLL(");
            this.handleBooleanProperty(parmString, obj.isCALLBACKANY(), "CBA", null);
            parmString.append(")");
        } else {
            parmString.append("NODLL ");
        }
        parmString.append("\n");
    }

    private void handleINFOOption(StringBuffer parmString, IDiagnosticObject obj) {
        if (obj.isINFO()) {
            if (obj.isINFO_ALL()) {
                parmString.append("INFO(ALL)\n");
            } else if (obj.isINFO_NONE()) {
                parmString.append("INFO(NONE)\n");
            } else {
                parmString.append("INFO(");
                this.handleBooleanProperty(parmString, obj.isCLS(), "CLS,", null);
                this.handleBooleanProperty(parmString, obj.isCMP(), "CMP,", null);
                this.handleBooleanProperty(parmString, obj.isCND(), "CND,", null);
                this.handleBooleanProperty(parmString, obj.isCNV(), "CNV,", null);
                this.handleBooleanProperty(parmString, obj.isCNS(), "CNS,", null);
                this.handleBooleanProperty(parmString, obj.isCPY(), "CPY,", null);
                this.handleBooleanProperty(parmString, obj.isEFF(), "EFF,", null);
                this.handleBooleanProperty(parmString, obj.isENU(), "ENU,", null);
                this.handleBooleanProperty(parmString, obj.isGEN(), "GEN,", null);
                this.handleBooleanProperty(parmString, obj.isGNR(), "GNR,", null);
                this.handleBooleanProperty(parmString, obj.isLAN(), "LAN,", null);
                this.handleBooleanProperty(parmString, obj.isPAR(), "PAR,", null);
                this.handleBooleanProperty(parmString, obj.isPOR(), "POR,", null);
                this.handleBooleanProperty(parmString, obj.isPPC(), "PPC,", null);
                this.handleBooleanProperty(parmString, obj.isPPT(), "PPT,", null);
                this.handleBooleanProperty(parmString, obj.isREA(), "REA,", null);
                this.handleBooleanProperty(parmString, obj.isRET(), "RET,", null);
                this.handleBooleanProperty(parmString, obj.isTRD(), "TRD,", null);
                this.handleBooleanProperty(parmString, obj.isUND(), "UND,", null);
                this.handleBooleanProperty(parmString, obj.isUSE(), "USE,", null);
                this.handleBooleanProperty(parmString, obj.isVFT(), "VFT", null);
                parmString.append(")\n");
            }
        } else {
            parmString.append("NOINFO\n");
        }
    }

    private void handleATTRIBUTEOption(StringBuffer parmString, IListingObject listingObject) {
        if (listingObject.isATTRIBUTE()) {
            parmString.append("ATTRIBUTE(");
            this.handleBooleanProperty(parmString, listingObject.isFULL(), "FULL", null);
            parmString.append(")\n");
        } else {
            parmString.append("NOATTRIBUTE\n");
        }
    }

    private void handleTESTProperty(StringBuffer buffer, LZOSResource resource, IDiagnosticObject obj) {
        if (obj.isTEST()) {
            if (this.isCPPResource(resource)) {
                buffer.append("TEST(");
                this.handleBooleanProperty(buffer, obj.isHOOK(), "HOOK", null);
                buffer.append(")");
            } else {
                buffer.append("TEST(");
                this.handleBooleanProperty(buffer, obj.isHOOK(), "HOOK,", null);
                this.handleBooleanProperty(buffer, obj.isSYM(), "SYM,", null);
                this.handleBooleanProperty(buffer, obj.isBLOCK(), "BLOCK,", null);
                this.handleBooleanProperty(buffer, obj.isLINE(), "LINE,", null);
                this.handleBooleanProperty(buffer, obj.isPATH(), "PATH", null);
                buffer.append(")");
            }
            buffer.append("\n");
        } else {
            buffer.append("NOTEST\n");
        }
    }

    private void handleBooleanPropertyWithNewLine(StringBuffer parmString, boolean booleanValue, String propertyName, String propertyValue) {
        this.handleBooleanProperty(parmString, booleanValue, propertyName, propertyValue);
        parmString.append('\n');
    }

    private void handleBooleanProperty(StringBuffer parmString, boolean booleanValue, String propertyName, String propertyValue) {
        if (booleanValue) {
            parmString.append(propertyName);
            if (propertyValue != null && propertyValue.length() > 0) {
                parmString.append("(");
                parmString.append(propertyValue);
                parmString.append(")");
            }
        } else {
            parmString.append("NO");
            parmString.append(propertyName);
        }
    }

    private boolean isCPPResource(LZOSResource resource) {
        return ((ILogicalFile)resource).getFileExtension().equalsIgnoreCase("cpp");
    }

    private String getSearchPath(String path) {
        String[] items = path.split(",");
        if (items != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                buffer.append("'");
                buffer.append(items[i]);
                buffer.append("'");
                if (i + 1 < items.length) {
                    buffer.append(",");
                }
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    public boolean writeJobCard(ILogicalResource resource) {
        boolean flag = true;
        String jobCard = this.manager.getPropertyOrOverride((Object)resource, "JOBCARD");
        int jobIndex = jobCard.indexOf("JOB");
        String restOfJobCard = "";
        if (jobIndex > -1) {
            restOfJobCard = " " + jobCard.substring(jobIndex);
        }
        if (!this.jobName.equals("")) {
            jobCard = "//" + this.jobName + restOfJobCard;
        }
        this.dumpAsIsJCL(jobCard, false);
        try {
            this.bufferedWriter.write(this.separator);
        }
        catch (IOException e) {
            e.printStackTrace();
            flag = false;
        }
        this.gettanewLine();
        return flag;
    }

    public void dumpAsIsJCL(String zAdditionalJCL, boolean addSpaces) {
        try {
            zAdditionalJCL = this.split(zAdditionalJCL);
            StringBuffer sb = new StringBuffer();
            sb.append(zAdditionalJCL.trim());
            String tempAdditionalJCLStr = "";
            int j = 0;
            while (j < sb.length()) {
                if (sb.charAt(j) == '\n') {
                    if (addSpaces) {
                        if (tempAdditionalJCLStr.startsWith(this.ss)) {
                            this.bufferedWriter.write(tempAdditionalJCLStr.trim());
                        } else {
                            this.bufferedWriter.write("     " + tempAdditionalJCLStr.trim());
                        }
                    } else {
                        this.bufferedWriter.write(tempAdditionalJCLStr.trim());
                    }
                    this.gettanewLine();
                    tempAdditionalJCLStr = "";
                } else {
                    tempAdditionalJCLStr = String.valueOf(tempAdditionalJCLStr) + sb.charAt(j);
                }
                ++j;
            }
            if (addSpaces) {
                if (tempAdditionalJCLStr.startsWith(this.ss)) {
                    this.bufferedWriter.write(tempAdditionalJCLStr.trim());
                } else {
                    this.bufferedWriter.write("     " + tempAdditionalJCLStr.trim());
                }
            } else {
                this.bufferedWriter.write(tempAdditionalJCLStr.trim());
            }
            this.gettanewLine();
        }
        catch (Exception exception) {}
    }

    private String split(String additionalJCL) {
        if (additionalJCL.length() > 71) {
            StringBuffer buffer = new StringBuffer(additionalJCL);
            String insertStr = null;
            insertStr = additionalJCL.endsWith("'") ? "\n//              " : "\n// ";
            int lastLinkeBreak = 0;
            int i = 0;
            while (i < buffer.length()) {
                if (i - lastLinkeBreak != 0 && (i - lastLinkeBreak) % 71 == 0) {
                    buffer.insert(i, insertStr);
                }
                if (buffer.charAt(i) == '\n') {
                    lastLinkeBreak = i;
                }
                ++i;
            }
            return buffer.toString();
        }
        return additionalJCL;
    }

    public boolean closeJCLStreamForGen(ILogicalResource logicalResource, Shell shell) {
        try {
            this.bufferedWriter.write(this.ss);
            this.gettanewLine();
            this.bufferedWriter.close();
            if (this.member != null && this.create) {
                FileInputStream inputStream = new FileInputStream(this.jclFilePath);
                if (this.newMember) {
                    this.member.create((InputStream)inputStream, true, null);
                } else {
                    this.member.setContents((InputStream)inputStream, true, null);
                }
            }
            ZOSResource resource = (ZOSResource)this.member.getDataset().findMember(this.member.getName());
            LogicalResourceFactory lResourceFactory = LogicalResourceFactory.eINSTANCE;
            LZOSProject project = ((LZOSDataSetMember)logicalResource).getProject();
            if (project != null && resource != null) {
                lResourceFactory.getLogicalResource((ILogicalContainer)project, (IPhysicalResource)resource);
            }
            MessageDialog.openInformation((Shell)shell, (String)NavigatorResources.JCLGENMessage_JCLGeneratedTitle, (String)(String.valueOf(NavigatorResources.JCLGENMessage_JCLIsInGeneratedFolderSubmitFromThatFolder) + "  " + this.genDSName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void gettanewLine() {
        try {
            this.bufferedWriter.newLine();
        }
        catch (Exception exception) {}
    }

    public boolean openJCLFileForGen(ILogicalResource resource, Shell shell) {
        boolean flag = true;
        String jclDataSetName = "";
        this.jclFileName = resource.getName();
        int index = this.jclFileName.indexOf(".");
        if (index > -1) {
            this.jclFileName = this.jclFileName.substring(0, index);
        }
        String dsProperty = this.manager.getPropertyOrOverride((Object)resource, "GENERATEDJCL");
        String jobCard = this.manager.getPropertyOrOverride((Object)resource, "JOBCARD");
        StringTokenizer st = new StringTokenizer(jobCard);
        while (st.hasMoreTokens()) {
            int i1;
            String token = st.nextToken();
            if (!token.startsWith("//") || (i1 = token.lastIndexOf("/")) <= -1) continue;
            this.jobName = token.substring(i1 + 1);
            break;
        }
        PBGenJCLFileNameInputDialog dialog = new PBGenJCLFileNameInputDialog(shell, dsProperty, this.jclFileName, this.jobName);
        dialog.open();
        if (dialog.isCanceled()) {
            return false;
        }
        this.jclFileName = dialog.getFileName().trim().toUpperCase();
        jclDataSetName = dialog.getPDSName().trim().toUpperCase();
        this.jobName = dialog.getJobName().trim().toUpperCase();
        this.genDSName = jclDataSetName;
        try {
            if (!this.tmpPrj.exists()) {
                this.tmpPrj.create(null);
                this.tmpPrj.open(null);
            } else if (!this.tmpPrj.isOpen()) {
                this.tmpPrj.open(null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.systemImage = (ZOSSystemImage)((LZOSDataSetMember)resource).getSubProject().getSystems()[0];
        ZOSCatalog root = (ZOSCatalog)this.systemImage.getRoot();
        ZOSPartitionedDataSet dataSet = (ZOSPartitionedDataSet)root.findMember(jclDataSetName);
        if (dataSet == null) {
            MessageDialog.openError((Shell)shell, (String)NavigatorResources.PBJCLGenAction_doesnotExistTitle, (String)ZOSProjectsResources.PBJCLGenAction_dataSetdoesnotExistMessage);
            return false;
        }
        this.member = (ZOSDataSetMember)dataSet.findMember(this.jclFileName);
        if (this.member == null) {
            IPhysicalResourceFactory physicalFactory = FactoryFactory.eINSTANCE.createPhysicalResourceFactoryRegistry().getFactory(((ZOSPartitionedDataSetImpl)dataSet).getClass(), ZOSDataSetMemberImpl.class);
            this.member = (ZOSDataSetMember)physicalFactory.getPhysicalResource((IContainer)dataSet, ZOSDataSetMember.class, this.jclFileName);
            this.newMember = true;
        }
        this.jclFilePath = String.valueOf(this.tmpPrj.getLocation().toString()) + File.separator + this.jclFileName;
        if (flag) {
            try {
                this.bufferedWriter = new BufferedWriter(new FileWriter(this.jclFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
                flag = false;
            }
        }
        return flag;
    }
}

