/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core.editor.contentassist;

import com.ibm.cdz.remote.core.editor.contentassist.RemoteContentAssistProcessor;
import com.ibm.ftt.cdz.core.MVSCDZUtility;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import java.util.List;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.services.clientserver.StringCompare;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MVSRemoteContentAssistProcessor
extends RemoteContentAssistProcessor {
    private static final Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

    public ICodeReaderFactory getCodeReaderFactory() {
        return MVSCDZUtility.getCodeReaderFactory();
    }

    protected void getIncludeProposalsFor(String path, String fileText, int offset, List proposals, char endChar) {
        char fileSep = '/';
        int sepIndex = fileText.lastIndexOf(fileSep);
        if (sepIndex > 0) {
            path = String.valueOf(path) + fileSep + fileText.substring(0, sepIndex);
            fileText = fileText.substring(sepIndex + 1, fileText.length());
        }
        try {
            Object mvsObject = this._resourceResolver.getResource(path);
            if (mvsObject instanceof MVSFileResource) {
                Object[] results = null;
                MVSFileResource fileResource = (MVSFileResource)mvsObject;
                String filter = String.valueOf(fileText) + "*";
                if (!fileResource.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter)) {
                    ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)fileResource.getAdapter(ISystemViewElementAdapter.class);
                    results = adapter.getChildren((IAdaptable)fileResource, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    results = fileResource.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
                }
                int i = 0;
                while (i < results.length) {
                    Object result = results[i];
                    MVSFileResource child = (MVSFileResource)result;
                    String name = child.getName().toLowerCase();
                    if (StringCompare.compare((String)filter, (String)name, (boolean)true)) {
                        String proposal = name;
                        String help = child.getAbsolutePath();
                        int replacementLength = fileText.length();
                        int replacementOffset = offset - replacementLength;
                        CProposalContextInformation info = new CProposalContextInformation(proposal, help);
                        CCompletionProposal cproposal = new CCompletionProposal(proposal, replacementOffset, replacementLength, fileImage, name, 1);
                        cproposal.setContextInformation((IContextInformation)info);
                        proposals.add(cproposal);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

