/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core.persistence;

import com.ibm.cdz.common.extnpt.api.IRemoteCompileObject;
import com.ibm.ftt.cdz.core.persistence.WDzRemoteCompileObject;
import com.ibm.ftt.projects.core.impl.logical.LogicalPropertyManager;
import com.ibm.ftt.projects.core.logical.ILogicalResource;
import com.ibm.ftt.resources.core.impl.PhysicalPropertyManager;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.rse.mvs.client.subsystems.MVSFileSubSystem;
import java.util.Properties;

public class PersistenceUtil {
    public static void setValue(Object object, String key, String value, boolean reset) {
        if (object instanceof ILogicalResource) {
            if (reset) {
                LogicalPropertyManager.getManager().setPersistentProperty(object, key, null);
            } else {
                LogicalPropertyManager.getManager().setPersistentProperty(object, key, value);
            }
        } else if (object instanceof IPhysicalResource) {
            if (reset) {
                PhysicalPropertyManager.getManager().setPersistentProperty((IPhysicalResource)object, key, null);
            } else {
                PhysicalPropertyManager.getManager().setPersistentProperty((IPhysicalResource)object, key, value);
            }
        } else if (object instanceof MVSFileResource) {
            if (reset) {
                PhysicalPropertyManager.getManager().setPersistentProperty((IPhysicalResource)((MVSFileResource)object).getZOSResource(), key, null);
            } else {
                PhysicalPropertyManager.getManager().setPersistentProperty((IPhysicalResource)((MVSFileResource)object).getZOSResource(), key, value);
            }
        } else {
            MVSFileSubSystem subsystem = (MVSFileSubSystem)object;
            Properties properties = subsystem.getSystemProperties();
            if (reset) {
                properties.remove(key);
            } else {
                properties.setProperty(key, value);
            }
        }
    }

    public static String loadValue(Object object, String key, String defaultValue, boolean reset) {
        Properties properties;
        MVSFileSubSystem subsystem;
        String value = null;
        if (object instanceof ILogicalResource) {
            value = reset ? ((LogicalPropertyManager)LogicalPropertyManager.getManager()).getDefaultValue((ILogicalResource)object, key) : LogicalPropertyManager.getManager().getPropertyOrOverride(object, key);
        } else if (object instanceof IPhysicalResource) {
            value = reset ? ((PhysicalPropertyManager)PhysicalPropertyManager.getManager()).getDefaultValue(key, (IPhysicalResource)object) : PhysicalPropertyManager.getManager().getPropertyOrOverride((IPhysicalResource)object, key);
        } else if (object instanceof MVSFileResource) {
            value = reset ? ((PhysicalPropertyManager)PhysicalPropertyManager.getManager()).getDefaultValue(key, (IPhysicalResource)((MVSFileResource)object).getZOSResource()) : PhysicalPropertyManager.getManager().getPropertyOrOverride((IPhysicalResource)((MVSFileResource)object).getZOSResource(), key);
        } else {
            subsystem = (MVSFileSubSystem)object;
            properties = subsystem.getSystemProperties();
            value = reset ? null : properties.getProperty(key);
        }
        if (value == null) {
            MVSFileSubSystem subsystem2;
            Properties properties2;
            String subSystemValue;
            IOSImage system;
            Object systemImpl;
            if (object instanceof MVSFileResource) {
                subsystem = (MVSFileSubSystem)((MVSFileResource)object).getSubSystem();
                properties = subsystem.getSystemProperties();
                String subSystemValue2 = properties.getProperty(key);
                if (subSystemValue2 != null) {
                    return subSystemValue2;
                }
            } else if (object instanceof IPhysicalResource && (systemImpl = (system = ((IPhysicalResource)object).getSystem()).getSystemImplementation()) instanceof MVSFileSubSystem && (subSystemValue = (properties2 = (subsystem2 = (MVSFileSubSystem)systemImpl).getSystemProperties()).getProperty(key)) != null) {
                return subSystemValue;
            }
            if (!reset && defaultValue != null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static IRemoteCompileObject getRemoteCompileObject(Object item) {
        try {
            WDzRemoteCompileObject compileObj = new WDzRemoteCompileObject(item);
            compileObj.load();
            return compileObj;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

