/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.qp.DupAction;
import com.ibm.dmh.qp.PersistRestartAction;
import com.ibm.dmh.qp.WorkException;
import com.ibm.dmh.qp.WorkProcessor;
import com.ibm.dmh.qp.WorkStatus;
import com.ibm.dmh.util.StringUtils;
import com.ibm.jjson.JsonSerializer;
import com.ibm.jjson.beans.annotation.Bean;
import java.io.Serializable;
import java.util.logging.Logger;

@Bean(properties={"workManager", "dupAction", "persistRestartAction", "deleteAfter", "persistOnShutdown", "cancelOnShutdown", "deleteIfCancelled", "persistIfStateIn", "deleteIfStateIn"})
public class WorkRules
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String workManager;
    public DupAction dupAction;
    public PersistRestartAction persistRestartAction;
    public long deleteAfter;
    public boolean persistOnShutdown;
    public boolean cancelOnShutdown;
    public boolean deleteIfCancelled;
    public WorkStatus[] persistIfStateIn;
    public WorkStatus[] deleteIfStateIn;
    public Logger logger;

    public WorkRules(String string, DupAction dupAction, boolean bl, PersistRestartAction persistRestartAction, WorkStatus[] workStatusArray, boolean bl2, long l, boolean bl3, WorkStatus[] workStatusArray2, Logger logger) throws WorkException {
        this.workManager = string;
        this.dupAction = dupAction;
        this.persistOnShutdown = bl;
        this.persistRestartAction = persistRestartAction;
        this.persistIfStateIn = workStatusArray;
        this.cancelOnShutdown = bl2;
        this.deleteAfter = l;
        this.deleteIfCancelled = bl3;
        this.deleteIfStateIn = workStatusArray2;
        this.logger = logger == null ? WorkProcessor.logger : logger;
        this.verify();
    }

    public WorkRules(String string, String string2, boolean bl, String string3, String string4, boolean bl2, long l, boolean bl3, String string5, String string6) throws WorkException {
        this.workManager = string;
        this.dupAction = DupAction.valueOf(string2.toUpperCase());
        this.persistOnShutdown = bl;
        this.cancelOnShutdown = bl2;
        this.deleteAfter = l;
        this.deleteIfCancelled = bl3;
        this.deleteIfStateIn = WorkStatus.valueOfNames(string5.toUpperCase());
        if (this.persistOnShutdown) {
            this.persistRestartAction = PersistRestartAction.valueOf(string3.toUpperCase());
            this.persistIfStateIn = WorkStatus.valueOfNames(string4.toUpperCase());
        } else {
            this.persistRestartAction = PersistRestartAction.DONT_CARE;
            this.persistIfStateIn = new WorkStatus[0];
        }
        this.logger = StringUtils.isEmpty(string6) ? WorkProcessor.logger : LoggerManager.getLogger(string6);
        this.verify();
    }

    private void verify() throws WorkException {
        if (!WorkProcessor.workManagers.containsKey(this.workManager)) {
            throw new WorkException("Invalid setting [workManager] specified on work rule:  " + this.workManager);
        }
        for (WorkStatus workStatus : this.deleteIfStateIn) {
            if (!workStatus.isInState(WorkStatus.UNKNOWN, WorkStatus.ACCEPTED, WorkStatus.STARTED, WorkStatus.ANY)) continue;
            throw new WorkException("Invalid setting [deleteIfStateIn] specified on work rule:  " + (Object)((Object)workStatus));
        }
    }

    public String toString() {
        return JsonSerializer.DEFAULT_CONDENSED.serialize((Object)this);
    }
}

