/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import java.util.Timer;
import java.util.TimerTask;

public class MemStats {
    public long maxMaxMemory;
    public long maxTotalMemory;
    public long maxFreeMemory;
    public long maxUsedMemory;
    public long initUsedMemory;
    private Runtime r = Runtime.getRuntime();
    private boolean isStarted;
    private Timer timer;

    public MemStats() {
        this.initUsedMemory = this.r.totalMemory() - this.r.freeMemory();
        this.calcStats();
    }

    private void calcStats() {
        long l = this.r.maxMemory();
        long l2 = this.r.totalMemory();
        long l3 = this.r.freeMemory();
        long l4 = l2 - l3;
        this.maxMaxMemory = Math.max(this.maxMaxMemory, l);
        this.maxTotalMemory = Math.max(this.maxTotalMemory, l2);
        this.maxFreeMemory = Math.max(this.maxFreeMemory, l3);
        this.maxUsedMemory = Math.max(this.maxUsedMemory, l4);
    }

    public String instantStats() {
        this.calcStats();
        return "Max memory=[" + this.getMaxMemory() + "], Total memory=[" + this.getTotalMemory() + "], Used memory=[" + this.getUsedMemory() + "], Delta used memory=[" + this.getDeltaUsedMemory() + "]";
    }

    public int getPercentFreeMemory() {
        this.calcStats();
        long l = this.r.totalMemory() - this.r.freeMemory();
        long l2 = this.r.maxMemory();
        return (int)((l2 - l) * 100L / l2);
    }

    public void startup(long l) {
        if (this.isStarted) {
            return;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                MemStats.this.calcStats();
            }
        }, l, l);
        this.isStarted = true;
    }

    public void shutdown() {
        this.timer.cancel();
    }

    public String getMaxMemory() {
        return MemStats.getByteLabel(this.r.maxMemory());
    }

    public String getMaxMaxMemory() {
        return MemStats.getByteLabel(this.maxMaxMemory);
    }

    public String getTotalMemory() {
        return MemStats.getByteLabel(this.r.totalMemory());
    }

    public String getMaxTotalMemory() {
        return MemStats.getByteLabel(this.maxTotalMemory);
    }

    public String getUsedMemory() {
        return MemStats.getByteLabel(this.r.totalMemory() - this.r.freeMemory());
    }

    public String getMaxUsedMemory() {
        return MemStats.getByteLabel(this.maxUsedMemory);
    }

    public String getFreeMemory() {
        return MemStats.getByteLabel(this.r.freeMemory());
    }

    public String getMaxFreeMemory() {
        return MemStats.getByteLabel(this.maxFreeMemory);
    }

    public String getDeltaUsedMemory() {
        return MemStats.getByteLabel(this.r.totalMemory() - this.r.freeMemory() - this.initUsedMemory);
    }

    private static String getByteLabel(long l) {
        double d = l;
        String string = null;
        int n = 0;
        if ((double)l >= 1.0E9) {
            d /= 1.0E9;
            n = 9;
            string = "GB";
        } else if ((double)l >= 1000000.0) {
            d /= 1000000.0;
            n = 6;
            string = "MB";
        } else if ((double)l >= 1000.0) {
            d /= 1000.0;
            n = 3;
            string = "kB";
        } else {
            return l + "  B";
        }
        return String.format("%." + n + "f %s", d, string);
    }
}

