/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.cfgmgr;

import com.ibm.dmh.cfgmgr.ConfigEntry;
import com.ibm.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.dmh.util.LocaleMgr;
import com.ibm.dmh.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFile {
    protected Map<String, List<String>> sectionContents = new LinkedHashMap<String, List<String>>();
    protected LinkedList<String> sectionList = new LinkedList();
    public LinkedList<String> loadErrors = new LinkedList();
    private String configFilePath;
    public String name;
    protected boolean hasBeenModified = false;
    protected ResourceBundle resourceBundle;
    protected Map<String, ConfigEntry> allValuesMap = new LinkedHashMap<String, ConfigEntry>();
    protected Map<String, Map<String, ConfigEntry>> sectionValuesMap = new LinkedHashMap<String, Map<String, ConfigEntry>>();

    public ConfigFile(String string) throws ConfigRuntimeException {
        this.configFilePath = string;
        this.name = ConfigFile.getFileName(string);
        this.readFile(string);
        if (!this.loadErrors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to load config file [" + this.name + "].", this.loadErrors);
        }
    }

    public ConfigFile(File file) throws ConfigRuntimeException {
        this(file.getAbsolutePath());
    }

    public ConfigFile(String string, boolean bl) throws ConfigRuntimeException {
        this.configFilePath = string;
        this.name = ConfigFile.getFileName(string);
        File file = new File(string);
        if (!file.exists() && bl) {
            this.readReader(new BufferedReader(new StringReader("")), string);
        } else {
            this.readFile(string);
        }
        if (!this.loadErrors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to load config file [" + this.name + "].", this.loadErrors);
        }
    }

    public ConfigFile(DataInputStream dataInputStream) throws ConfigRuntimeException {
        this.configFilePath = null;
        this.name = null;
        this.readReader(new BufferedReader(new InputStreamReader(dataInputStream)), null);
        if (!this.loadErrors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to load config file [" + this.name + "].", this.loadErrors);
        }
    }

    public ConfigFile() {
        this.configFilePath = null;
        this.name = null;
    }

    public void resolveAllValues() throws ConfigRuntimeException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, ConfigEntry> entry : this.allValuesMap.entrySet()) {
            ConfigEntry configEntry = entry.getValue();
            try {
                configEntry.getValue();
            }
            catch (ConfigRuntimeException configRuntimeException) {
                linkedList.add(configRuntimeException.getLocalizedMessage());
            }
        }
        if (!linkedList.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to resolve all values in config file [" + this.name + "].", linkedList);
        }
    }

    private void readFile(String string) {
        BufferedReader bufferedReader = null;
        File file = new File(string);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            this.loadErrors.add("Could not create config file on filesystem:  [" + string + "], msg=[" + iOException.getLocalizedMessage() + "]");
            return;
        }
        try {
            this.resourceBundle = LocaleMgr.getBundleForFile(file);
        }
        catch (Exception exception) {
            this.loadErrors.add("Could not load resource bundle for config file.  configFilePath=[" + string + "], msg=[" + exception.getLocalizedMessage() + "]");
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), LocaleMgr.getExternalDefaultEncoding()));
            this.readReader(bufferedReader, string);
            bufferedReader.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.loadErrors.add("Unsupported encoding exception caught trying to load config file.  configFilePath=[" + string + "], encoding=[" + LocaleMgr.getExternalDefaultEncoding() + "], msg=[" + unsupportedEncodingException.getLocalizedMessage() + "]");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.loadErrors.add("Could not find config file.  configFilePath=[" + string + "], msg=[" + fileNotFoundException.getLocalizedMessage() + "]");
        }
        catch (IOException iOException) {
            this.loadErrors.add("Error occurred while trying to close reader.  configFilePath=[" + string + "], msg=[" + iOException.getLocalizedMessage() + "]");
        }
    }

    private void readReader(BufferedReader bufferedReader, String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        LinkedHashMap<String, ConfigEntry> linkedHashMap = new LinkedHashMap<String, ConfigEntry>();
        this.sectionValuesMap.put(string2, linkedHashMap);
        this.sectionList.add(null);
        this.sectionContents.put(null, linkedList);
        String string3 = null;
        int n = 0;
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                ++n;
                if (!(string3 = string3.trim()).startsWith("#")) {
                    int n2;
                    if (string3.startsWith("[")) {
                        n2 = string3.indexOf("]");
                        if (n2 == -1) {
                            this.loadErrors.add("Missing ']' at line " + n + " of config file [" + this.configFilePath + "]");
                            continue;
                        }
                        string2 = string3.substring(1, n2).trim();
                        if (this.sectionValuesMap.containsKey(string2)) {
                            this.loadErrors.add("Duplicate sections [" + string2 + "] defined in config file [" + this.configFilePath + "]");
                            continue;
                        }
                        linkedHashMap = new LinkedHashMap();
                        this.sectionValuesMap.put(string2, linkedHashMap);
                        this.sectionList.add(string2);
                        linkedList = new LinkedList();
                        this.sectionContents.put(string2, linkedList);
                    } else if (string3.indexOf(61) != -1) {
                        boolean bl;
                        n2 = string3.indexOf(61);
                        String string4 = string3.substring(0, n2).trim();
                        String string5 = string3.substring(n2 + 1).trim();
                        String string6 = null;
                        while (string5.endsWith("\\") && !string5.endsWith("\\\\") && (string6 = bufferedReader.readLine()) != null) {
                            string5 = string5.substring(0, string5.length() - 1) + string6.trim();
                        }
                        if (string5.indexOf(92) != -1) {
                            string5 = StringUtils.unEscapeChars(string5, new char[]{'\\'});
                        }
                        boolean bl2 = bl = string4.charAt(string4.length() - 1) == '*';
                        if (bl) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        ConfigEntry configEntry = null;
                        try {
                            configEntry = new ConfigEntry(this, string2, string4, string5, bl, n);
                            linkedHashMap.put(string4, configEntry);
                            this.allValuesMap.put(configEntry.configKey, configEntry);
                            string3 = "=" + configEntry.configKey;
                        }
                        catch (ConfigRuntimeException configRuntimeException) {
                            this.loadErrors.add(configRuntimeException.getMessage());
                        }
                    }
                }
                linkedList.addLast(string3);
            }
        }
        catch (IOException iOException) {
            this.loadErrors.add("IOException [" + iOException.getLocalizedMessage() + "] caught at line [" + n + "] while trying to read config file [" + this.configFilePath + "] at line [" + n + "]");
        }
    }

    public synchronized String get(String string) throws ConfigRuntimeException {
        String string2 = this.get(string, null, null);
        if (string2 == null) {
            throw new ConfigRuntimeException("Key '" + string + "' not found in file '" + this.configFilePath + "'");
        }
        return string2;
    }

    public synchronized String get(String string, Object[] objectArray) throws ConfigRuntimeException {
        String string2 = this.get(string, objectArray, null);
        if (string2 == null) {
            throw new ConfigRuntimeException("Key '" + string + "' not found in file '" + this.configFilePath + "'");
        }
        return string2;
    }

    public synchronized String get(String string, String string2) throws ConfigRuntimeException {
        return this.get(string, null, string2);
    }

    public synchronized String get(String string, Object[] objectArray, String string2) throws ConfigRuntimeException {
        ConfigEntry configEntry = this.allValuesMap.get(string);
        if (configEntry == null) {
            return string2;
        }
        try {
            if (objectArray == null) {
                return configEntry.getValue();
            }
            return configEntry.getValue(objectArray);
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught trying to retrieve value for [" + string + "] in config file [" + this.configFilePath + "]", exception);
        }
    }

    public synchronized boolean isEncoded(String string) {
        ConfigEntry configEntry = this.allValuesMap.get(string);
        return configEntry == null ? false : configEntry.isEncoded;
    }

    public synchronized void set(String string, String string2, boolean bl) throws ConfigRuntimeException {
        try {
            ConfigEntry configEntry = this.allValuesMap.get(string);
            if (configEntry == null && !bl) {
                throw new ConfigRuntimeException("Key [" + string + "] not found in file [" + this.configFilePath + "]");
            }
            if (configEntry == null) {
                Object object;
                String string3 = null;
                int n = string.indexOf(".");
                if (n != -1) {
                    string3 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                configEntry = new ConfigEntry(this, string3, string, string2, false, 0);
                Map<String, ConfigEntry> map = this.sectionValuesMap.get(string3);
                if (map == null) {
                    String string4;
                    map = new LinkedHashMap<String, ConfigEntry>();
                    this.sectionValuesMap.put(string3, map);
                    object = this.sectionList.getLast();
                    LinkedList linkedList = (LinkedList)this.sectionContents.get(object);
                    String string5 = string4 = linkedList.isEmpty() ? "" : (String)linkedList.getLast();
                    if (string4 == null || !string4.trim().equals("")) {
                        linkedList.addLast("");
                    }
                    this.sectionList.addLast(configEntry.sectionName);
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    linkedList2.addLast("[" + configEntry.sectionName + "]");
                    this.sectionContents.put(configEntry.sectionName, linkedList2);
                }
                map.put(configEntry.propName, configEntry);
                this.allValuesMap.put(configEntry.configKey, configEntry);
                object = (LinkedList)this.sectionContents.get(configEntry.sectionName);
                if (((AbstractCollection)object).isEmpty()) {
                    ((LinkedList)object).add("");
                }
                if (((String)((LinkedList)object).getLast()).equals("")) {
                    ((LinkedList)object).removeLast();
                }
                ((LinkedList)object).addLast("=" + configEntry.configKey);
                ((LinkedList)object).addLast("");
            } else {
                configEntry.setValue(string2);
            }
            this.hasBeenModified = true;
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught trying to set value for [" + string + "] in config file [" + this.configFilePath + "]", exception);
        }
    }

    public synchronized void remove(String string) throws ConfigRuntimeException {
        try {
            Map<String, ConfigEntry> map;
            ConfigEntry configEntry = this.allValuesMap.get(string);
            if (configEntry == null) {
                return;
            }
            this.allValuesMap.remove(string);
            String string2 = null;
            String string3 = null;
            int n = string.indexOf(".");
            if (n != -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if ((map = this.sectionValuesMap.get(string2)) != null) {
                map.remove(string3);
                List<String> list = this.sectionContents.get(string2);
                int n2 = -1;
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).toString().equals("=" + string)) continue;
                    n2 = i;
                }
                if (n2 != -1) {
                    list.remove(n2);
                }
            }
            this.hasBeenModified = true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught trying to remove value for [" + string + "] in config file [" + this.configFilePath + "]", exception);
        }
    }

    public synchronized Map<String, String> getSectionMap(String string) throws ConfigRuntimeException {
        Map<String, ConfigEntry> map;
        if (string.equals("")) {
            string = null;
        }
        if ((map = this.sectionValuesMap.get(string)) == null) {
            throw new ConfigRuntimeException("Section '" + string + "' not found in file '" + this.configFilePath + "'");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string2 : map.keySet()) {
            ConfigEntry configEntry = map.get(string2);
            linkedHashMap.put(string2, configEntry.getValue());
        }
        return linkedHashMap;
    }

    public synchronized Set<String> getKeyNamesInSection(String string) throws ConfigRuntimeException {
        Map<String, ConfigEntry> map;
        if (string.equals("")) {
            string = null;
        }
        if ((map = this.sectionValuesMap.get(string)) == null) {
            throw new ConfigRuntimeException("Section '" + string + "' not found in file '" + this.configFilePath + "'");
        }
        return map.keySet();
    }

    public synchronized Set<String> getKeyNames() {
        return this.allValuesMap.keySet();
    }

    public synchronized Set<String> getSectionNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(this.sectionValuesMap.keySet());
        linkedHashSet.remove(null);
        return linkedHashSet;
    }

    public synchronized void printOn(PrintWriter printWriter) {
        for (String string : this.sectionList) {
            List<String> list = this.sectionContents.get(string);
            for (String string2 : list) {
                if (string2.length() > 0 && string2.charAt(0) == '=') {
                    ConfigEntry configEntry = this.allValuesMap.get(string2.substring(1));
                    if (configEntry == null) {
                        System.err.println("ERROR: No config file entry for [" + string2.substring(1) + "]");
                        continue;
                    }
                    String string3 = configEntry.rawValue;
                    if (string3.endsWith("\\")) {
                        string3 = string3 + "\\";
                    }
                    printWriter.println(configEntry.propName + (configEntry.isEncoded ? "*" : "") + " = " + string3);
                    continue;
                }
                printWriter.println(string2);
            }
        }
        printWriter.flush();
    }

    public synchronized void save() throws ConfigRuntimeException {
        this.save(this.configFilePath);
    }

    public synchronized void save(String string) throws ConfigRuntimeException {
        if (!this.hasBeenModified) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            File file = new File(string);
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), LocaleMgr.getExternalDefaultEncoding())));
            this.printOn(printWriter);
            this.hasBeenModified = false;
        }
        catch (IOException iOException) {
            throw new ConfigRuntimeException("Trouble saving configuration to file \"" + string + "\"", iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public synchronized String getContents() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printOn(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    public synchronized String getLocation() {
        return this.configFilePath;
    }

    private static String getFileName(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        if ((n = (string = string.replace('\\', '/')).lastIndexOf(47)) == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static void main(String[] stringArray) {
    }
}

