/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonParser;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class XmlSerializer {
    public static int FORMAT_CONDENSED = 1;
    public static int FORMAT_PRETTY = 2;

    public static String serialize(String string, Object object, int n, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        XmlSerializer.serialize(string, object, stringWriter, n, 0, bl);
        return stringWriter.toString();
    }

    public static String serialize(String string, Object object, int n) {
        return XmlSerializer.serialize(string, object, n, true);
    }

    public static String serialize(String string, Object object) {
        return XmlSerializer.serialize(string, object, FORMAT_PRETTY, true);
    }

    public static String serializeFromJson(String string, String string2, int n) throws IOException {
        return XmlSerializer.serialize(string, JsonParser.parse(string2), n);
    }

    private static void serialize(String string, Object object, StringWriter stringWriter, int n, int n2, boolean bl) {
        string = XmlSerializer.encodeName(string);
        String string2 = null;
        string2 = object instanceof Map ? "object" : (object instanceof Collection ? "array" : (object instanceof Number ? "number" : (object instanceof Boolean ? "boolean" : (object == null ? "null" : "string"))));
        if (n == FORMAT_PRETTY) {
            XmlSerializer.indent(stringWriter, n2);
        }
        stringWriter.write(string == null ? "<" + string2 + ">" : "<" + string + (bl ? " type='" + string2 + "'" : "") + ">");
        if (object instanceof Map) {
            stringWriter.write(10);
            Map map = (Map)object;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                XmlSerializer.serialize(string3, map.get(string3), stringWriter, n, n2 + 1, bl);
            }
        } else if (object instanceof Collection) {
            stringWriter.write(10);
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                XmlSerializer.serialize(null, iterator.next(), stringWriter, n, n2 + 1, bl);
            }
        } else if (object instanceof Number || object instanceof Boolean) {
            stringWriter.write(object.toString());
        } else if (object != null) {
            stringWriter.write(XmlSerializer.toValidXml(object.toString()));
        }
        if ((object instanceof Map || object instanceof Collection) && n == FORMAT_PRETTY) {
            XmlSerializer.indent(stringWriter, n2);
        }
        stringWriter.write(string == null ? "</" + string2 + ">\n" : "</" + string + ">\n");
    }

    private static void indent(StringWriter stringWriter, int n) {
        for (int i = 0; i < n; ++i) {
            stringWriter.write(9);
        }
    }

    private static String encodeName(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < string.length() && !bl; ++i) {
            char c = string.charAt(i);
            if (!(c >= '0' && c <= '\t' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && c != '_') continue;
            bl = true;
        }
        if (bl) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(cArray.length + 12);
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c >= '0' && c <= '\t' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append("_x" + XmlSerializer.toHex(c) + "_");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String toValidXml(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (Character.isISOControl(c)) {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String toHex(int n) {
        char[] cArray = new char[4];
        int n2 = n % 16;
        cArray[3] = (char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2);
        int n3 = 16;
        for (int i = 1; i < 4; ++i) {
            n2 = n / n3 % 16;
            n3 <<= 4;
            cArray[3 - i] = (char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2);
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        String string = "{\t  name:'John Smith', \t  address: {\t       streetAddress: '21 2nd Street',\t       city: 'New York',\t       state: 'NY',\t       postalCode: 10021,\t   },\t   phoneNumbers: [\t      '212 555-1111',\t      '212 555-2222'\t   ],\t   additionalInfo: null,\t   remote: false,\t   height: 62.4,\t   'fico score':  ' > 640'}";
        Map map = (Map)JsonParser.parse(string);
        String string2 = XmlSerializer.serialize(null, map, FORMAT_PRETTY);
        System.out.println(string2);
    }
}

