/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.SecurityException;

public class PasswordCipherUtil {
    private static final byte XOR_MASK = 95;
    private static final String[] DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS = new String[]{"xor"};
    private static String[] _supported_crypto_algorithms = null;

    public static byte[] decipher(byte[] byArray, String string) throws SecurityException {
        if (string == null) {
            throw new SecurityException(4);
        }
        byte[] byArray2 = null;
        if (!string.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            throw new SecurityException(4);
        }
        byArray2 = PasswordCipherUtil.xor(byArray);
        if (byArray2 == null) {
            throw new SecurityException(1);
        }
        return byArray2;
    }

    public static byte[] encipher(byte[] byArray, String string) throws SecurityException {
        if (string == null) {
            throw new SecurityException(4);
        }
        byte[] byArray2 = null;
        if (!string.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            throw new SecurityException(4);
        }
        byArray2 = PasswordCipherUtil.xor(byArray);
        if (byArray2 == null) {
            throw new SecurityException(1);
        }
        return byArray2;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return _supported_crypto_algorithms;
    }

    private static byte[] xor(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = (byte)(0x5F ^ byArray[i]);
            }
        }
        return byArray2;
    }

    static {
        if (_supported_crypto_algorithms == null) {
            _supported_crypto_algorithms = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS;
        }
    }
}

