/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.wsaa.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcDriverAdmin {
    private static Driver jdbcDriver = null;
    private static String databaseUrl;
    private static boolean isInitialized;

    public static void init(String databaseUrl, String jdbcDriverName, String jdbcDriverPath) throws Exception {
        if (isInitialized) {
            return;
        }
        JdbcDriverAdmin.databaseUrl = databaseUrl;
        File jdbcDriverFile = new File(jdbcDriverPath);
        URL[] urls = new URL[]{jdbcDriverFile.toURL()};
        URLClassLoader cl = new URLClassLoader(urls, JdbcDriverAdmin.class.getClassLoader());
        jdbcDriver = (Driver)cl.loadClass(jdbcDriverName).newInstance();
        isInitialized = true;
    }

    public static Connection getConnection(String userId, String pw) throws SQLException {
        Properties p = new Properties();
        if (!userId.equalsIgnoreCase("*default*") && !StringUtils.isEmpty((String)userId)) {
            p.setProperty("user", userId);
            p.setProperty("password", pw);
        }
        return jdbcDriver.connect(databaseUrl, p);
    }

    static {
        isInitialized = false;
    }
}

