/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.SqlUtils;
import com.ibm.wsaa.util.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DbColumn {
    public String name = null;
    public int type = -1;
    public boolean allowNull = false;
    public long size = -1L;
    public Object defaultValue = null;

    public DbColumn(String name, String typeAndSize, String defaultValue, String canBeNullStr) {
        this(name, SqlUtils.getSqlTypeInt(typeAndSize), SqlUtils.getSqlSize(typeAndSize), defaultValue, canBeNullStr);
    }

    public DbColumn(String name, int type, long size, String defaultValue, String canBeNullStr) {
        this.name = name;
        this.type = type == -1 ? 12 : type;
        this.size = SqlUtils.sqlTypeHasSize(type) ? size : 0L;
        this.allowNull = canBeNullStr != null && StringUtils.getBoolean((String)canBeNullStr);
        if (defaultValue == null || defaultValue.equalsIgnoreCase("NULL")) {
            this.defaultValue = null;
            return;
        }
        try {
            switch (type) {
                case 4: {
                    this.defaultValue = Integer.decode(StringUtils.isNumeric((String)defaultValue) ? defaultValue : "0");
                    break;
                }
                case 5: {
                    this.defaultValue = Short.decode(StringUtils.isNumeric((String)defaultValue) ? defaultValue : "0");
                    break;
                }
                case 6: {
                    this.defaultValue = new Float(defaultValue);
                    break;
                }
                case 91: {
                    this.defaultValue = defaultValue;
                    break;
                }
                case 93: {
                    this.defaultValue = defaultValue;
                    break;
                }
                case 92: {
                    this.defaultValue = defaultValue;
                    break;
                }
                case 1: {
                    if (defaultValue.length() > 1) {
                        this.defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                        break;
                    }
                    this.defaultValue = defaultValue;
                    break;
                }
                case 8: {
                    this.defaultValue = new Double(defaultValue);
                    break;
                }
                case -1: 
                case 12: {
                    if (defaultValue.length() > 1) {
                        this.defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                        break;
                    }
                    this.defaultValue = defaultValue;
                    break;
                }
                default: {
                    this.defaultValue = defaultValue;
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            this.defaultValue = null;
        }
    }

    public Object getGeneratedDefaultValue() {
        switch (this.type) {
            case 5: {
                return new Short(0);
            }
            case 4: {
                return new Integer(0);
            }
            case 6: {
                return new Float(0.0f);
            }
            case 93: {
                return new Timestamp(new Date().getTime());
            }
            case 91: {
                return new java.sql.Date(new Date().getTime());
            }
            case 92: {
                return new Time(new Date().getTime());
            }
            case 1: {
                return "_";
            }
            case 8: {
                return new Double(0.0);
            }
            case -1: 
            case 12: {
                return "";
            }
        }
        return null;
    }
}

