;	PROGRAM TO SET H25 PRINTER CHARACTER AND LINE WIDTH
;	ENTER PSET25 n  (n = 10, 12, 13 (13.2), or 16 (16.5))
;	TO SET CHARACTERS PER INCH.
;
;	ENTER PSET n (n = 6 or 8)
;	TO SET LINES PER INCH.

M	EQU	Byte Ptr 0[BX]

PSET25	SEGMENT
	ASSUME	CS:PSET25,DS:PSET25,SS:PSET25,ES:PSET25

	ORG	100H
START:	MOV	BX,80H			;POINT TO ARGUMENT
	MOV	AL,M			;GET COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GETARG			;YES
	MOV	DX,(Offset INST)
	MOV	AH,9
	INT	21H			;PRINT INSTRUCTIONS
	JMP	SHORT EXIT
GETARG:	INC	BX			;MOVE TO HEXT CHAR
	MOV	AL,M			;GET IT
	CMP	AL,' '			;SPACE?
	JZ	GETARG			;SKIP SPACES
	CMP	AL,'1'			;ONE?
	JZ	SETCHR			;YES, SET CHARACTER WIDTH
	CMP	AL,'6'			;SIX?
	MOV	CH,'0'			;ASSUME IT IS
	JZ	SETLN			;YES, SET LINE HEIGHT
	CMP	AL,'8'			;EIGHT?
	MOV	CH,'2'			;ASSUME IT IS
	JNZ	EXIT			;BAD ENTRY
SETLN:	MOV	AL,CH			;GET LINE SET PARAMETER
	MOV	Byte Ptr LNVAL,AL	;PUT IT IN LINE STRING
	MOV	BX,(Offset LSTRING)	;POINT TO LINE STRING
	JMP	SHORT PLOOP		;PRINT IT
SETCHR:	INC	BX
	MOV	AL,M			;GET NEXT CHARACTER
	MOV	CH,'1'			;ASSUME 10 CPI
	CMP	AL,'0'			;IS IT 10?
	JZ	PSET			;YES, SET PRINTER
	MOV	CH,'2'			;ASSUME 12 CPI
	CMP	AL,'2'			;IS IT 12?
	JZ	PSET			;YES
	MOV	CH,'3'			;ASSUME 13.2 CPI
	CMP	AL,'3'			;IS IT 13?
	JZ	PSET			;YES
	MOV	CH,'4'			;ASSUME 16.5 CPI
	CMP	AL,'6'			;IS IT 16?
	JZ	PSET			;YES
EXIT:
	INT	20H			;RETURN TO Z-DOS
PSET:	MOV	AL,CH
	MOV	Byte Ptr SETVAL,AL	;SET UP PRINTER SETUP STRING
	MOV	BX,(Offset PSTRING)	;GET SETUP STRING
PLOOP:	MOV	AL,M			;GET CHARACTER
	OR	AL,AL			;END OF STRING?
	JZ	EXIT			;IF SO, EXIT
	MOV	DL,AL			;PUT CHAR IN E
	MOV	AH,5			;PRINT FUNCTION
	PUSH	BX			;SAVE POINTER
	INT	21H			;CALL BDOS TO PRINT
	POP	BX			;RESTORE POINTER
	INC	BX			;INCREMENT IT
	JMP	SHORT PLOOP		;CONTINUE PRINTING

INST	DB	0DH,0AH
	DB	'PSET for the H/Z25.',0DH,0AH,0DH,0AH
	DB	'Enter PSET25 [arg], where [arg] =',0DH,0AH,0DH,0AH
	DB	'10 -- set 10 Characters Per Inch.',0DH,0AH
	DB	'12 -- set 12 CPI.',0DH,0AH
	DB	'13 -- set 13.2 CPI.',0DH,0AH
	DB	'16 -- set 16.5 CPI.',0DH,0AH
	DB	'6  -- set 6 Lines Per Inch.',0DH,0AH
	DB	'8  -- set 8 LPI.',0DH,0AH,'$'
PSTRING	DB	1BH,'['
SETVAL	DB	'0w',0DH,0
LSTRING	DB	1BH,'['
LNVAL	DB	'0x',0DH,0
PSET25	ENDS
	END	START
