# CFLAGS and library paths for BEEP
# written 15 December 1999 by Ben Gertzfield <che@debian.org>

dnl Usage:
dnl AM_PATH_BEEP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
dnl Example:
dnl AM_PATH_BEEP(0.9.6, , AC_MSG_ERROR([*** BEEP >= 0.9.6 not installed - please install first ***]))
dnl
dnl Defines BEEP_CFLAGS, BEEP_LIBS, BEEP_DATA_DIR, BEEP_PLUGIN_DIR, 
dnl BEEP_VISUALIZATION_PLUGIN_DIR, BEEP_INPUT_PLUGIN_DIR, 
dnl BEEP_OUTPUT_PLUGIN_DIR, BEEP_GENERAL_PLUGIN_DIR, BEEP_EFFECT_PLUGIN_DIR,
dnl and BEEP_VERSION for your plugin pleasure.
dnl

dnl BEEP_TEST_VERSION(AVAILABLE-VERSION, NEEDED-VERSION [, ACTION-IF-OKAY [, ACTION-IF-NOT-OKAY]])
AC_DEFUN(BEEP_TEST_VERSION, [

# Determine which version number is greater. Prints 2 to stdout if	
# the second number is greater, 1 if the first number is greater,	
# 0 if the numbers are equal.						
									
# Written 15 December 1999 by Ben Gertzfield <che@debian.org>		
# Revised 15 December 1999 by Jim Monty <monty@primenet.com>		
									
    AC_PROG_AWK
    beep_got_version=[` $AWK '						\
BEGIN {									\
    print vercmp(ARGV[1], ARGV[2]);					\
}									\
									\
function vercmp(ver1, ver2,    ver1arr, ver2arr,			\
                               ver1len, ver2len,			\
                               ver1int, ver2int, len, i, p) {		\
									\
    ver1len = split(ver1, ver1arr, /\./);				\
    ver2len = split(ver2, ver2arr, /\./);				\
									\
    len = ver1len > ver2len ? ver1len : ver2len;			\
									\
    for (i = 1; i <= len; i++) {					\
        p = 1000 ^ (len - i);						\
        ver1int += ver1arr[i] * p;					\
        ver2int += ver2arr[i] * p;					\
    }									\
									\
    if (ver1int < ver2int)						\
        return 2;							\
    else if (ver1int > ver2int)						\
        return 1;							\
    else								\
        return 0;							\
}' $1 $2`]								

    if test $beep_got_version -eq 2; then 	# failure
	ifelse([$4], , :, $4)			
    else  					# success!
	ifelse([$3], , :, $3)
    fi
])

AC_DEFUN(AM_PATH_BEEP,
[
AC_ARG_WITH(beep-prefix,[  --with-beep-prefix=PFX  Prefix where BEEP is installed (optional)],
	beep_config_prefix="$withval", beep_config_prefix="")
AC_ARG_WITH(beep-exec-prefix,[  --with-beep-exec-prefix=PFX Exec prefix where BEEP is installed (optional)],
	beep_config_exec_prefix="$withval", beep_config_exec_prefix="")

if test x$beep_config_exec_prefix != x; then
    beep_config_args="$beep_config_args --exec-prefix=$beep_config_exec_prefix"
    if test x${BEEP_CONFIG+set} != xset; then
	BEEP_CONFIG=$beep_config_exec_prefix/bin/beep-config
    fi
fi

if test x$beep_config_prefix != x; then
    beep_config_args="$beep_config_args --prefix=$beep_config_prefix"
    if test x${BEEP_CONFIG+set} != xset; then
  	BEEP_CONFIG=$beep_config_prefix/bin/beep-config
    fi
fi

AC_PATH_PROG(BEEP_CONFIG, beep-config, no)
min_beep_version=ifelse([$1], ,0.9.5.1, $1)

if test "$BEEP_CONFIG" = "no"; then
    no_beep=yes
else
    BEEP_CFLAGS=`$BEEP_CONFIG $beep_config_args --cflags`
    BEEP_LIBS=`$BEEP_CONFIG $beep_config_args --libs`
    BEEP_VERSION=`$BEEP_CONFIG $beep_config_args --version`
    BEEP_DATA_DIR=`$BEEP_CONFIG $beep_config_args --data-dir`
    BEEP_PLUGIN_DIR=`$BEEP_CONFIG $beep_config_args --plugin-dir`
    BEEP_VISUALIZATION_PLUGIN_DIR=`$BEEP_CONFIG $beep_config_args \
					--visualization-plugin-dir`
    BEEP_INPUT_PLUGIN_DIR=`$BEEP_CONFIG $beep_config_args --input-plugin-dir`
    BEEP_OUTPUT_PLUGIN_DIR=`$BEEP_CONFIG $beep_config_args --output-plugin-dir`
    BEEP_EFFECT_PLUGIN_DIR=`$BEEP_CONFIG $beep_config_args --effect-plugin-dir`
    BEEP_GENERAL_PLUGIN_DIR=`$BEEP_CONFIG $beep_config_args --general-plugin-dir`

    BEEP_TEST_VERSION($BEEP_VERSION, $min_beep_version, ,no_beep=version)
fi

AC_MSG_CHECKING(for BEEP - version >= $min_beep_version)

if test "x$no_beep" = x; then
    AC_MSG_RESULT(yes)
    ifelse([$2], , :, [$2])
else
    AC_MSG_RESULT(no)

    if test "$BEEP_CONFIG" = "no" ; then
	echo "*** The beep-config script installed by BMP could not be found."
      	echo "*** If BMP was installed in PREFIX, make sure PREFIX/bin is in"
	echo "*** your path, or set the BEEP_CONFIG environment variable to the"
	echo "*** full path to beep-config."
    else
	if test "$no_beep" = "version"; then
	    echo "*** An old version of BMP, $BEEP_VERSION, was found."
	    echo "*** You need a version of BMP newer than $min_beep_version."
	    echo "*** The latest version of BMP is always available from"
	    echo "*** http://www.linux-media.net/beep/"
	    echo "***"

            echo "*** If you have already installed a sufficiently new version, this error"
            echo "*** probably means that the wrong copy of the beep-config shell script is"
            echo "*** being found. The easiest way to fix this is to remove the old version"
            echo "*** of BEEP, but you can also set the BEEP_CONFIG environment to point to the"
            echo "*** correct copy of beep-config. (In this case, you will have to"
            echo "*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf"
            echo "*** so that the correct libraries are found at run-time)"
	fi
    fi
    BEEP_CFLAGS=""
    BEEP_LIBS=""
    ifelse([$3], , :, [$3])
fi
AC_SUBST(BEEP_CFLAGS)
AC_SUBST(BEEP_LIBS)
AC_SUBST(BEEP_VERSION)
AC_SUBST(BEEP_DATA_DIR)
AC_SUBST(BEEP_PLUGIN_DIR)
AC_SUBST(BEEP_VISUALIZATION_PLUGIN_DIR)
AC_SUBST(BEEP_INPUT_PLUGIN_DIR)
AC_SUBST(BEEP_OUTPUT_PLUGIN_DIR)
AC_SUBST(BEEP_GENERAL_PLUGIN_DIR)
AC_SUBST(BEEP_EFFECT_PLUGIN_DIR)
])
