/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/soundcard.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"

extern GtkLabel *TimeLabel;
extern GtkCList *FileList;
GtkWidget *FileSelector;

int
main (int argc, char *argv[])
{
  GtkWidget *GPE_Media;
  GtkWidget *scale;
  int handle,r;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  gtk_rc_parse("/usr/share/gpe-media/gpe-media.gtkrc");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  GPE_Media = create_GPE_Media ();
  FileSelector = create_fileselection();
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(FileSelector),"/mnt/");

  scale=lookup_widget(GPE_Media, "Slider");
  gtk_widget_hide(scale);
  gtk_widget_show (GPE_Media);

  scale = lookup_widget (GPE_Media, "Slider");
  gtk_signal_connect (GTK_OBJECT (GTK_RANGE (scale)->adjustment),
  	"value_changed", GTK_SIGNAL_FUNC (on_Slider_changed), NULL);

  handle=open("/dev/mixer",O_RDWR);
  if (handle > 0) {
	scale = lookup_widget (GPE_Media, "VolScale");
	if (ioctl(handle,MIXER_READ(SOUND_MIXER_VOLUME),&r) == 0) {
		gtk_adjustment_set_value(GTK_RANGE (scale)->adjustment, (r & 0xff));
		gtk_signal_connect (GTK_OBJECT (GTK_RANGE (scale)->adjustment),
			"value_changed", GTK_SIGNAL_FUNC (on_VolScale_changed), NULL);
	} else {
		gtk_widget_set_sensitive(scale, 0);
	}
	scale = lookup_widget (GPE_Media, "BassScale");
	if (ioctl(handle,MIXER_READ(SOUND_MIXER_BASS),&r) == 0) {
		gtk_adjustment_set_value(GTK_RANGE (scale)->adjustment, (r & 0xff));
		gtk_signal_connect (GTK_OBJECT (GTK_RANGE (scale)->adjustment),
			"value_changed", GTK_SIGNAL_FUNC (on_BassScale_changed), NULL);
	} else {
		gtk_widget_set_sensitive(scale, 0);
		gtk_widget_hide(scale);
	}
	scale = lookup_widget (GPE_Media, "TrebleScale");
	if (ioctl(handle,MIXER_READ(SOUND_MIXER_TREBLE),&r) == 0) {
		gtk_adjustment_set_value(GTK_RANGE (scale)->adjustment, (r & 0xff));
		gtk_signal_connect (GTK_OBJECT (GTK_RANGE (scale)->adjustment),
			"value_changed", GTK_SIGNAL_FUNC (on_TrebleScale_changed), NULL);
	} else {
		gtk_widget_set_sensitive(scale, 0);
		gtk_widget_hide(scale);
	}
	close(handle);
  } else {
	scale = lookup_widget (GPE_Media, "VolScale");
	gtk_widget_set_sensitive(scale, 0);
	scale = lookup_widget (GPE_Media, "BassScale");
	gtk_widget_set_sensitive(scale, 0);
	scale = lookup_widget (GPE_Media, "TrebleScale");
	gtk_widget_set_sensitive(scale, 0);
  }

  /* FIXME: we are global! */
  TimeLabel=(GtkLabel *)lookup_widget (GPE_Media, "Time");
  FileList=(GtkCList *)lookup_widget (GPE_Media, "FileList");

  gtk_main ();
  return 0;
}

