/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Alerts_H
#define Alerts_H

#define ALERT_CAPTION_PREFIX                                 "NX - "

#define INTERNAL_ERROR_ALERT                                 1
#define INTERNAL_ERROR_ALERT_TYPE                            "ok"
#define INTERNAL_ERROR_ALERT_STRING                          \
"\
An unrecoverable internal error was detected.\n\
Press OK to terminate the current session.\n\
"

#define CLOSE_DEAD_X_CONNECTION_CLIENT_ALERT                 2
#define CLOSE_DEAD_X_CONNECTION_CLIENT_ALERT_TYPE            "yesno"
#define CLOSE_DEAD_X_CONNECTION_CLIENT_ALERT_STRING          \
"\
One of the applications currently in use is not responding.\n\
Do you want to terminate the current session?\n\
"

#define CLOSE_DEAD_X_CONNECTION_SERVER_ALERT                 3
#define CLOSE_DEAD_X_CONNECTION_SERVER_ALERT_TYPE            "yesno"
#define CLOSE_DEAD_X_CONNECTION_SERVER_ALERT_STRING          \
"\
One of the applications did not behave correctly and caused\n\
the X server to stop responding. Do you want to terminate the\n\
current session?\n\
"

#define CLOSE_DEAD_PROXY_CONNECTION_CLIENT_ALERT             4
#define CLOSE_DEAD_PROXY_CONNECTION_CLIENT_ALERT_TYPE        NULL
#define CLOSE_DEAD_PROXY_CONNECTION_CLIENT_ALERT_STRING      NULL

#define CLOSE_DEAD_PROXY_CONNECTION_SERVER_ALERT             5
#define CLOSE_DEAD_PROXY_CONNECTION_SERVER_ALERT_TYPE        "yesno"
#define CLOSE_DEAD_PROXY_CONNECTION_SERVER_ALERT_STRING      \
"\
No response received from the remote server.\n\
Do you want to terminate the current session?\n\
"

#define RESTART_DEAD_PROXY_CONNECTION_CLIENT_ALERT           6
#define RESTART_DEAD_PROXY_CONNECTION_CLIENT_ALERT_TYPE      NULL
#define RESTART_DEAD_PROXY_CONNECTION_CLIENT_ALERT_STRING    NULL

#define RESTART_DEAD_PROXY_CONNECTION_SERVER_ALERT           7
#define RESTART_DEAD_PROXY_CONNECTION_SERVER_ALERT_TYPE      "yesno"
#define RESTART_DEAD_PROXY_CONNECTION_SERVER_ALERT_STRING    \
"\
Connection with remote server was shut down. NX will try\n\
to establish a new server connection. Session could have\n\
been left in a unusable state. Do you want to terminate\n\
the session?\n\
"

#define CLOSE_UNRESPONSIVE_X_SERVER_ALERT                    8
#define CLOSE_UNRESPONSIVE_X_SERVER_ALERT_TYPE               "panic"
#define CLOSE_UNRESPONSIVE_X_SERVER_ALERT_STRING             \
"\
You pressed the key sequence CTRL+ALT+SHIFT+ESC.\n\
This is probably because your X server has become\n\
unresponsive. Session will be terminated in 30\n\
seconds unless you abort the procedure by pressing\n\
the Cancel button.\n\
"

#define WRONG_PROXY_VERSION_ALERT                            9
#define WRONG_PROXY_VERSION_ALERT_TYPE                       "ok"
#define WRONG_PROXY_VERSION_ALERT_STRING                     \
"\
Local NX libraries version " VERSION " do not match\n\
NX version of remote server. Please check the server's\n\
error log to find out which client version you need to\n\
install to be able to run sessions on remote server.\n\
"

#define FAILED_PROXY_CONNECTION_CLIENT_ALERT                 10
#define FAILED_PROXY_CONNECTION_CLIENT_ALERT_TYPE            NULL
#define FAILED_PROXY_CONNECTION_CLIENT_ALERT_STRING          NULL

#define FAILED_PROXY_CONNECTION_SERVER_ALERT                 11
#define FAILED_PROXY_CONNECTION_SERVER_ALERT_TYPE            "yesno"
#define FAILED_PROXY_CONNECTION_SERVER_ALERT_STRING          \
"\
Could not yet establish connection to remote proxy.\n\
Do you want to terminate the current session?\n\
"

#define MISSING_PROXY_CACHE_ALERT                            12
#define MISSING_PROXY_CACHE_ALERT_TYPE                       "ok"
#define MISSING_PROXY_CACHE_ALERT_STRING                     \
"\
NX was unable to negotiate a cache for this session.\n\
This may happen if this is the first time you run a\n\
session on this server or if cache was corrupted or\n\
produced by an incompatible NX version.\n\
"

#endif /* Alerts_H */
