/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "ClientReadBuffer.h"

#include "ClientChannel.h"

int ClientReadBuffer::locateMessage(const unsigned char *start,
                                        const unsigned char *end,
                                            unsigned int &controlLength,
                                                unsigned int &dataLength,
                                                    unsigned int &trailerLength)
{
  unsigned int size = end - start;

  if (firstMessage_)
  {
    if (size < 12)
    {
      return 0;
    }

    if (*start == 0x42)
    {
      bigEndian_ = 1;
    }
    else
    {
      bigEndian_ = 0;
    }

    channel_ -> setBigEndian(bigEndian_);

    dataLength = 12 + RoundUp4(GetUINT(start + 6, bigEndian_)) +
                          RoundUp4(GetUINT(start + 8, bigEndian_));
  }
  else
  {
    if (size < 4)
    {
      return 0;
    }

    dataLength = (GetUINT(start + 2, bigEndian_) << 2);
  }

  if (size < dataLength)
  {
    return 0;
  }

  firstMessage_ = 0;

  controlLength = 0;
  trailerLength = 0;

  return 1;
}
