/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef NX_H
#define NX_H

#ifdef __cplusplus
extern "C" {
#endif

#define NX_FD_ANY                      -1

#define NX_MODE_ANY                    -1
#define NX_MODE_CLIENT                  1
#define NX_MODE_SERVER                  2

#define NX_DISPLAY_ANY                  NULL

extern int NXCreateProcess(int fd, int mode, const char* display);

extern int NXCreateProcessWithInfo(int fd, int mode, const char* display, const char* info);

extern int NXCreateThread(int fd, int mode, const char* display);

extern int NXCreateThreadWithInfo(int fd, int mode, const char* display, const char* info);

extern int NXProxy(int fd, int mode, const char* display);

extern int NXDialog(const char *caption, const char *message,
                        const char *type, int local, const char* display);

extern int NXWatchdog(int timeout);

extern int NXKeeper(int caches, int images, const char *root);

extern void NXExit(int code);

/*
 * Checks the parameters for subsequent
 * initialization of the NX transport.
 * These are the experimental and are
 * currently for internal use.
 */

extern int NXTransportCreate(int fd, int mode, const char* display);

/*
 * Connects or waits for connection from
 * the remote peer, negotiates the session
 * parameters and initializes the proxy.
 */

extern int NXTransportInit(void);

/*
 * Restore the proxy connection in case
 * of failure.
 */

extern int NXTransportRestore(void);

/*
 * Prepare the file sets and the timeout
 * for a later execution of the select().
 */

extern int NXTransportPrepare(void);

/*
 * True if there is a valid internal
 * NX connection.
 */

int NXTransportCheck(void);

/*
 * Returns the best suited timeout for
 * the next call to select().
 */

extern const struct timeval *NXTransportTimeout(void);

/*
 * Call select() to find out if any of
 * the handled descriptors has data.
 */

extern int NXTransportSelect(void);

/*
 * Perform the required actions on all
 * the descriptors having I/O pending.
 */

extern int NXTransportExecute(void);

#ifdef __cplusplus
}
#endif

#endif /* NXproto_H */
