/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "OpcodeStore.h"

OpcodeStore::OpcodeStore()
{
  //
  // Assign opcodes according to NX protocol.
  //

  getControlParameters = X_NXGetControlParameters;
  getCleanupParameters = X_NXGetCleanupParameters;
  getImageParameters   = X_NXGetImageParameters;
  getUnpackParameters  = X_NXGetUnpackParameters;
  getShmemParameters   = X_NXGetShmemParameters;

  startSplit  = X_NXStartSplit;
  endSplit    = X_NXEndSplit;
  split       = X_NXSplit;
  commitSplit = X_NXCommitSplit;
  abortSplit  = X_NXAbortSplit;

  sync  = X_NXSync;
  karma = X_NXKarma;

  setExposeEvents = X_NXSetExposeEvents;

  setUnpackGeometry = X_NXSetUnpackGeometry;
  setUnpackColormap = X_NXSetUnpackColormap;
  setUnpackAlpha    = X_NXSetUnpackAlpha;

  putPackedImage = X_NXPutPackedImage;

  freeUnpack = X_NXFreeUnpack;

  //
  // These must be fetched from X server.
  //

  shapeExtension  = 0;
  renderExtension = 0;

  //
  // Events sent as ClientMessage.
  //

  splitNotify = NXSplitNotify;
  syncNotify  = NXSyncNotify;
  karmaNotify = NXKarmaNotify;

  resetNotify      = NXResetNotify;
  congestionNotify = NXCongestionNotify;

  //
  // TODO: This must become a generic
  // collect notify event to be used
  // for multiple replies.
  //

  collectImageNotify = NXCollectImageNotify;
}

OpcodeStore::~OpcodeStore()
{
}
