/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "Control.h"

#include "PositionCache.h"

PositionCache::PositionCache()
{
  for (int i = 0; i < 32; i++)
  {
    if (control -> isProtoStep2() == 1)
    {
      base_[i] = new IntCache(8);
    }
    else if (i < 16)
    {
      base_[i] = new IntCache(32);
    }
  }

  slot_ = 0;
  last_ = 0;

  //
  // Only used in protocol
  // version less than 1.2.
  //

  mask_ = 0;
}

PositionCache::~PositionCache()
{
  for (int i = 0; i < 32; i++)
  {
    if (control -> isProtoStep2() == 1)
    {
      delete base_[i];
    }
    else if (i < 16)
    {
      delete base_[i];
    }
  }
}
