/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef ServerProxy_H
#define ServerProxy_H

#include <sys/types.h>
#include <sys/socket.h>

#include "Proxy.h"

#include "Misc.h"

//
// Set the verbosity level.
//

#undef  TEST
#undef  DEBUG

class ServerProxy : public Proxy
{
  public:

  ServerProxy(int proxyFd, const char *xServerDisplay, int xServerAddrFamily,
                  sockaddr * xServerAddr, unsigned int xServerAddrLength,
                      int syncServerPort, int keybdServerPort,
                          int sambaServerPort, int mediaServerPort);

  virtual ~ServerProxy();

  protected:

  virtual int handleNewXConnection(int clientFd);

  virtual int handleNewXConnectionFromProxy(int channelId);

  virtual int handleNewSyncConnection(int clientFd);

  virtual int handleNewSyncConnectionFromProxy(int channelId);

  virtual int handleNewKeybdConnection(int clientFd);

  virtual int handleNewKeybdConnectionFromProxy(int channelId);

  virtual int handleNewSambaConnection(int clientFd);

  virtual int handleNewSambaConnectionFromProxy(int channelId);

  virtual int handleNewMediaConnection(int clientFd);

  virtual int handleNewMediaConnectionFromProxy(int channelId);

  //
  // Nothing to send to the X server.
  //

  virtual int handleNotify(T_notification_type type)
  {
    return 0;
  }

  //
  // Implement persistence according to proxy mode.
  //

  virtual int handleCheckLoad(T_proxy_load type);
  virtual int handleCheckSave();

  virtual int handleLoadFromProxy();
  virtual int handleSaveFromProxy();

  virtual int handleSaveStores(ostream *cachefs, md5_state_t *md5StateStream,
                                   md5_state_t *md5StateClient) const;

  virtual int handleLoadStores(istream *cachefs, md5_state_t *md5StateStream) const;

  //
  // Nothing to do for wakeup timeouts.
  //

  virtual void handleUpdateWakeup() const
  {
  }

  //
  // This proxy has motion events and
  // doesn't have split and wakeup.
  //

  virtual int needSplit() const
  {
    return -1;
  }

  virtual int needMotion() const;

  virtual int needWakeup() const
  {
    return -1;
  }

  virtual int getFd(int channelId) const
  {
    if (channelId < 0 || channelId >= CONNECTIONS_LIMIT)
    {
      return -1;
    }
    else
    {
      return fdMap_[channelId];
    }
  }

  virtual int getChannel(int fd) const
  {
    if (fd < 0 || fd >= CONNECTIONS_LIMIT)
    {
      return -1;
    }
    else
    {
      return channelMap_[fd];
    }
  }

  virtual void cleanupChannelMap(int channelId)
  {
    int fd = fdMap_[channelId];

    if (fd != -1)
    {
      fdMap_[channelId] = -1;

      channelMap_[fd] = -1;
    }
  }

  private:

  //
  // Utility function used to realize
  // a new connection.
  //

  int checkNewGenericConnectionFromProxy(int channelId, T_channel_type type,
                                             char *hostname, int port, char *label);

  int handleNewGenericConnectionFromProxy(int channelId, T_channel_type type,
                                              char *hostname, int port, char *label);

  int channelMap_[CONNECTIONS_LIMIT];
  int fdMap_[CONNECTIONS_LIMIT];

  int xServerAddrFamily_;
  sockaddr *xServerAddr_;
  unsigned int xServerAddrLength_;

  //
  // This is the name of the X display where
  // we are going to forward connections.
  //

  char *xServerDisplay_;

  //
  // Ports where to forward extended services'
  // TCP connections.
  //

  int syncServerPort_;
  int keybdServerPort_;
  int sambaServerPort_;
  int mediaServerPort_;
};

#endif /* ServerProxy_H */
