/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Unpack_H
#define Unpack_H

#include "NXpack.h"

//
// Pixel geometry of channel's display.
//

typedef struct
{
  unsigned int depth1_bpp;
  unsigned int depth4_bpp;
  unsigned int depth8_bpp;
  unsigned int depth16_bpp;
  unsigned int depth24_bpp;
  unsigned int depth32_bpp;
  unsigned int red_mask;
  unsigned int green_mask;
  unsigned int blue_mask;
} T_geometry;

int GetBitsPerPixel(T_geometry *geometry, unsigned int depth);

typedef ColorMask T_colormask;

//
// Colormap is used to remap colors
// from source to destination depth.
//
 
typedef struct
{
  unsigned int entries;
  unsigned int *data;
} T_colormap;

//
// Alpha channel data is added to 32
// bits images at the time they are
// unpacked.
//
 
typedef struct
{
  unsigned int entries;
  unsigned char *data;
} T_alpha;

int Unpack8(T_geometry *geometry, const T_colormask *colormask, int src_depth, int src_width,
                int src_height, unsigned char *src_data, int src_size, int dst_depth,
                    int dst_width, int dst_height, unsigned char *dst_data, int dst_size);

int Unpack16(T_geometry *geometry, const T_colormask *colormask, int src_depth, int src_width,
                 int src_height, unsigned char *src_data, int src_size, int dst_depth,
                     int dst_width, int dst_height, unsigned char *dst_data, int dst_size);

int Unpack24(T_geometry *geometry, const T_colormask *colormask, int src_depth, int src_width,
                 int src_height, unsigned char *src_data, int src_size, int dst_depth,
                     int dst_width, int dst_height, unsigned char *dst_data, int dst_size);

int Unpack8(T_geometry *geometry, T_colormap *colormap, int src_depth, int src_width,
                int src_height, unsigned char *src_data, int src_size, int dst_depth,
                    int dst_width, int dst_height, unsigned char *dst_data, int dst_size);

int UnpackRDPTo8(unsigned char *output, int width, int height,
                     unsigned char *input, int size);

int UnpackRDPText(unsigned int drawable, unsigned int gcontext, int big_endian,
                      unsigned char *src_data, unsigned int src_size,
                          unsigned char *dst_data, unsigned int dst_size);

int UnpackHextile(int src_width, int src_height, unsigned char *src_data,
                      int src_size, int dst_depth, int dst_width, int dst_height,
                          unsigned char *dst_data, int dst_size);

int UnpackAlpha(T_alpha *alpha, unsigned char *dst_data,
                    int dst_size, int big_endian);

#endif /* Unpack_H */
