(define (logo-pixmap-generator width 
			  text
			  size
			  font
			  active
			  logo_1
			  font_color_1
			  light-active
			  dark-active
			  logo_0
			  font_color_0
			  light-inactive
			  dark-inactive)
  (gimp-palette-set-foreground '(0 0 0))
  (if (= active TRUE)
  (set! logo logo_1)
  (set! logo logo_0))
  (let* ((new-image (car (gimp-file-load 1 logo logo)))
	(logo-width (car (gimp-image-width new-image)))
	(image-height (car (gimp-image-height new-image)))
;	(new-image (car (gimp-image-new width 20 RGB)))
	(menu_shadow (car (gimp-text-fontname new-image -1 0 0 text -1 1 size 0 font)))
	(layer0 (car (gimp-layer-new new-image width image-height RGBA-IMAGE "Blend" 100 NORMAL-MODE)))
	(text-width (car (gimp-drawable-width menu_shadow)))
	(text-height (car (gimp-drawable-height menu_shadow)))
	(text-offset-x (+ (- (/ (- width logo-width) 2) (/ text-width 2)) logo-width))
	(text-offset-y (- (/ (- image-height text-height) 2) 1)))
	(if (= active TRUE)
	(gimp-palette-set-foreground font_color_1)
	(gimp-palette-set-foreground font_color_0))
	(set! menu_title (car (gimp-text-fontname new-image -1 0 0 text -1 1 size 0 font)))
	(gimp-image-resize new-image width image-height 0 0)
	(gimp-image-add-layer new-image layer0 3)
	(gimp-layer-set-offsets menu_title text-offset-x text-offset-y)
	(gimp-layer-set-offsets menu_shadow (+ text-offset-x 1) (+ text-offset-y 1))
;	(plug-in-blur 1 new-image menu_shadow)
	(if (= active TRUE)
	(gimp-palette-set-foreground light-active)
	(gimp-palette-set-foreground light-inactive))
	(if (= active FALSE)
	(gimp-palette-set-background dark-inactive)
	(gimp-palette-set-background dark-active))
	(gimp-edit-blend layer0 FG-BG-RGB-MODE NORMAL-MODE GRADIENT-LINEAR 100 0 REPEAT-NONE FALSE FALSE 0 0 TRUE 0 0 0 (- image-height 1))
	(gimp-display-new new-image)
	(gimp-image-set-filename new-image "menu.xpm")
  ))
(script-fu-register "logo-pixmap-generator"
		    _"<Toolbox>/Xtns/Script-Fu/XdTv/Logo Menu maker..."
		    "Generate menu pixmaps with logos for XdTv"
		    "BlindMan"
		    "BlindMan"
		    "2004"
		    ""
		    SF-ADJUSTMENT _"Menu width" '(300 100 500 1 10 0 0)
		    SF-STRING     _"Text" "Menu XdTv"
		    SF-ADJUSTMENT _"Font size (pixels)" '(11 10 25 1 3 0 1)
		    SF-FONT       _"Font" "Tahoma Bold"
		    SF-TOGGLE     _"Active Menu" TRUE
		    SF-FILENAME   _"Active logo" (string-append "" gimp-data-dir "/scripts/images/logo_1.png")
		    SF-COLOR      _"Active Text Color" '(255 239 64)
		    SF-COLOR      _"Light Active Color" '(68 104 174)
		    SF-COLOR      _"Dark Active Color" '(0 51 146)
		    SF-FILENAME   _"Inactive logo" (string-append "" gimp-data-dir "/scripts/images/logo_0.png")
		    SF-COLOR      _"Inactive text Color" '(255 252 216)
		    SF-COLOR      _"Light Inactive Color" '(178 178 178)
		    SF-COLOR      _"Dark Inactive Color" '(112 112 112))
