#include <stdio.h>
#include <stdlib.h>
#include <locale.h>
#include <string.h>
#include <pthread.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "vt.h"
#include "misc.h"
#include "fdset.h"
#include "xio.h"
#include "vbi.h"
#include "lang.h"
#include "cache.h"
#include "ui.h"

int alevt_debug = 0;
int alevt_in_use = 0;
int real_alevt_in_use = 0;
int request_alevt_stop = 0;
extern int vbifd;
extern int debug;
extern void capture_sub_init(struct vbi *v);
extern void capture_sub_stop(void);
extern int subtitles_pgno;

static pthread_t alevt_thread;
int alevt_rval;

static Display* dpy = 0;
static Window wnd = 0;

static struct vtwin *grand_father = 0;

/* current args for next start() */
static char *geometry = 0;
static char *dpy_name = 0;
static char *vbi_name = NULL;
static struct xio *xio = 0;
static struct vbi *vbi = 0;
static int fine_tune = 1; // auto = 999;
static int erc = 1;
static int newbttv = -1;

static void
usage(FILE *fp, int exitval)
{
    fprintf(fp, "\nUsage: %s [options]\n", prgname);
    fprintf(fp,
	    "\n"
	    "  Valid options:\t\t\t\t\t\tDefault:\n"
	    "    --help or -h\n"
	    "    --version or -v\n"
	    "    --debug or -debug\n"
	    //"    -vbi <vbidev>\t\t/dev/vbi\n"
	    "    -copyright or - \n"
	    "    -editor or -ed \n"
	    "    -display or -d <dpy>\t\t\t\t\t$DISPLAY\n"
	    "    -geometry or -g <geo>\t\t\t\t\t41x25\n"
	    "    -finetune or -f <-4..4|auto>\t\t\t\t0\n"
	    "    -child or -c ppp[.ss]\n"
	    "    [-parent] or -p ppp[.ss]\t\t\t\t\t900\n"
	    //"    -oldbttv\t\t(for bttv <0.5.20)\n"
	    "    -[no]erc or -[n]e\t\t\t\t\t\tenabled\n"
	    "    -[no]bell or -[n]b\t\t\t\t\t\tenabled\n"
	    "    -charset or -latin latin-1/2/koi8-r/koi/iso8859-7/el\tlatin-1\n"
	    "\n"
	    "  Order is important!  Each page number\n"
	    "  opens a new window with the previously\n"
	    "  given geometry, device, and display.\n"
	    "\n"
	    "  ppp[.ss] stands for a page number and an\n"
	    "  optional subpage number (ie 123.4).  If\n"
	    "  the subpage number is omitted the first\n"
	    "  transmitted subpage is shown.\n"
	    "\n"
	    "  The -child option requires a parent\n"
	    "  window.  So, it must be preceeded by\n"
	    "  a parent or another child window.\n"
	);
    //exit(exitval);
    alevt_rval = exitval;
    pthread_exit(&alevt_rval);
}


static int
arg_pgno(char *p, int *subno)
{
    char *end;
    int pgno;

    *subno = ANY_SUB;
    if (*p)
    {
	pgno = strtol(p, &end, 16);
	if ((*end == ':' || *end == '/' || *end == '.') && end[1])
	    *subno = strtol(end + 1, &end, 16);
	if (*end == 0)
	    if (pgno >= 0x100 && pgno <= 0x999)
		if (*subno == ANY_SUB || (*subno >= 0x00 && *subno <= 0x3f7f))
		    return pgno;
    }
    alevt_in_use = 0;
    real_alevt_in_use = 0;
    fatal("%s: invalid page number", p);
}


static struct vtwin *
start(int argc, char **argv, struct vtwin *parent, int pgno, int subno)
{
    if (vbi == 0)
	vbi = vbi_open(vbi_name, cache_open(), fine_tune, newbttv);
    if (vbi == 0)
	fatal("cannot open %s", vbi_name);
    if (vbi->cache)
	vbi->cache->op->mode(vbi->cache, CACHE_MODE_ERC, erc);

    if (xio == 0)
	xio = xio_open_dpy(dpy_name, argc, argv);
    if (xio == 0)
	fatal("cannot open display");

    parent = vtwin_new(xio, vbi, geometry, parent, pgno, subno);
    if (parent == 0)
	fatal("cannot create window");
    return parent;
}


static int
option(int argc, char **argv, int *ind, char **arg)
{
  static struct { char *nam, *altnam; int arg; } opts[] = {
        //{ "-vbi", "-dev", 1 },
	//{ "-newbttv", "-new", 0 },
	//{ "-oldbttv", "-old", 0 },
	{ "-display", "-d", 1 },          //  1
	{ "-geometry", "-g", 1 },         //  2
	{ "-child", "-c", 1 },            //  3
	{ "-editor", "-ed", 0 },          //  4
	{ "-parent", "-p", 1 },           //  5
	{ "--version", "-v", 0 },         //  6
	{ "--help", "-h", 0 },            //  7
	{ "-finetune", "-f", 1 },         // 8
	{ "-debug", "--debug", 0 },       // 9
	{ "-copyright", "-", 0 },        // 10
	{ "-erc", "-e", 0 },              // 11
	{ "-noerc", "-ne", 0 },           // 12
	{ "-bell", "-b", 0 },             // 13
	{ "-nobell", "-nb", 0 },          // 14
	{ "-charset", "-latin", 1 },      // 15
    };
    int i;

    if (*ind >= argc)
	return 0;

    *arg = argv[(*ind)++];
    for (i = 0; i < NELEM(opts); ++i)
	if (streq(*arg, opts[i].nam) || streq(*arg, opts[i].altnam))
	{
	    if (opts[i].arg)
		if (*ind < argc)
		    *arg = argv[(*ind)++];
		else
		{
		  alevt_in_use = 0;
		  real_alevt_in_use = 0;
		  fatal("option %s requires an argument", *arg);
		}
	    return i+1;
	}

    if (**arg == '-')
    {
        alevt_in_use = 0;
	real_alevt_in_use = 0;
	fatal("%s: invalid option", *arg);
	usage(stderr, 1);
    }

    return -1;
}


void
set_argc_argv(int *argc, char ***argv, char *cmdline)
{
  int i;
  char **arg_v;
  char *tok;
  char *local;
  char *s;
  
  // NEED TO MAKE A LOCAL MODIFIABLE COPY OF THE CMDLINE
  local = malloc(strlen(cmdline)+1);
  strcpy(local,cmdline);

  tok = strtok_r(local, " ",&s);
  i = 1;
  arg_v = (char **)malloc(i*sizeof(char *));
  arg_v[i-1] = (char *)malloc(strlen(tok)+1);
  strcpy(arg_v[i-1], tok);

  for(tok=strtok_r(NULL, " ",&s); tok != (char *)NULL; tok=strtok_r(NULL, " ",&s))
    {
      i++;
      arg_v = (char **)realloc(arg_v, i*sizeof(char *));
      arg_v[i -1] = (char *)malloc(strlen(tok)+1);
      strcpy(arg_v[i-1], tok);
    }
  *argc = i;
  *argv = arg_v;
  free(local);
}

/*
int
main(int argc, char **argv)
*/
void *
alevt_main (void *cmdline)
{
  //    struct vtwin *parent = 0;
  int pgno, subno;
  int opt, ind;
  char *arg;
  int argc;
  char **argv;
  int i;

  stop_subtitles();

  alevt_in_use = 1;
  real_alevt_in_use = 1;

  if (cmdline)
    set_argc_argv(&argc, &argv, (char *)cmdline);
  else
    {
      argc = 1;
      argv = (char **)malloc(sizeof(char *));
      argv[0] = (char *)malloc(6);
      strcpy(argv[0], "alevt");
    }

  setlocale (LC_CTYPE, "");

  setprgname(argv[0]);

  memset(&fds, 0, sizeof (struct fdset));
  fdset_init(fds);

  ind = 1;
  while (opt = option(argc, argv, &ind, &arg))
	switch (opt)
      {

      //case 1:	// vbi (no need to use it as alevt use vbi from xdTV)
		//vbi_name = arg;
		//vbi = 0;
		//grand_father = 0;
		//break;
      //case 9:	// newbttv (no need to use it as alevt use vbi from xdTV)
		//newbttv = 1;
		//break;
      //case 10:// oldbttv (no need to use it as alevt use vbi from xdTV)
		//newbttv = 0;
		//break;

      case 1:	// display
		dpy_name = arg;
		xio = 0;
		grand_father = 0;
		break;

      case 2:	// geometry
		geometry = arg;
		break;

      case 3:	// child
		if (grand_father == 0)
          	  fatal("-child requires a parent window");
		pgno = arg_pgno(arg, &subno);
		grand_father = start(argc, argv, grand_father, pgno, subno);
		geometry = 0;
		break;

      case 4:	// editor
		enab_editor = 1;
		break;

      case 5:	// parent

      case 6:	// version
		printf("AleVT Version "VERSION" adapted to xdTV\n");
		//exit(0);
		alevt_in_use = 0;
		real_alevt_in_use = 0;
        	alevt_rval = 0;
        	pthread_exit(&alevt_rval);

      case 7:	// help
		alevt_in_use = 0;
		real_alevt_in_use = 0;
		usage(stdout, 0);
		break;
      case 8:	// finetune
		if (streq(arg, "auto"))
          	  fine_tune = 999;
		else
          	  fine_tune = strtol(arg, 0, 10);
		break;

      case 9:	// debug
		alevt_debug++;
		break;

      case 10:	// copyright
		printf("Copyright 2000 by E. Toernig, froese@gmx.de\n");
		//exit(0);
		alevt_in_use = 0;
		real_alevt_in_use = 0;
        	alevt_rval = 0;
        	pthread_exit(&alevt_rval);

      case 11:	// erc
        	erc = 1;
		break;

      case 12:	// noerc
        	erc = 0;
		break;

      case 13:	// bell
        	bell = 1;
		break;

      case 14:	// nobell
        	bell = 0;
		break;

      case 15:	// charset
		if (streq(arg, "latin-1") || streq(arg, "1"))
          	    latin1 = LATIN1;
		else if (streq(arg, "latin-2") || streq(arg, "2"))
          	    latin1 = LATIN2;
		else if (streq(arg, "koi8-r") || streq(arg, "koi"))
		    latin1 = KOI8;
		else if (streq(arg, "iso8859-7") || streq(arg, "el"))
		    latin1 = GREEK;
		else
	  	    fatal("bad charset (not latin-1/2/koi8-r/koi/iso8859-7/el)");
		break;

      case -1:	// non-option arg
		pgno = arg_pgno(arg, &subno);
		grand_father = start(argc, argv, 0, pgno, subno);
		geometry = 0;
		break;
      }


  if (grand_father == 0)
    grand_father = start(argc, argv, 0, 0x100, ANY_SUB);
  dpy = grand_father->xw->xio->dpy;
  wnd = grand_father->xw->win;

  capture_sub_init(vbi);

  xio_event_loop();

  capture_sub_stop();

  vbi_close(vbi);
  xio_init_dpys();
  grand_father = 0;
  xio = 0;
  vbi = 0;

  for(i=0;i<argc;i++)
    free(argv[i]);
  free(argv);

  //exit(0);
  XCloseDisplay(dpy);
  real_alevt_in_use = 0;
  alevt_rval = 0;

  if(subtitles_pgno != -1)
    start_subtitles();
  else
    alevt_in_use = 0;

  pthread_exit(&alevt_rval);

}

void
start_alevt (char *arg)
{
  int ret;
  request_alevt_stop=0;
  ret = pthread_create (&alevt_thread, NULL, alevt_main, (void *) arg);
  if (debug)
    {
      if (ret == 0)
        printf ("Alevt started.\n");
      else
        printf ("Alevt start failed.\n");
    }
}

void
stop_alevt (void)
{
  void *ret;
  
  if (grand_father == 0)
    {
      if (debug)
        fprintf(stderr, "Alevt seems to already have been closed !\n");
    }
  else
    {
      request_alevt_stop = 1;
    }

  if (debug)
    fprintf(stderr, "stop_alevt: waiting for thread to terminate\n");

  pthread_join (alevt_thread, &ret);

  if (debug)
    printf ("Alevt stopped.\n");

}
