/*****************************************************************************
 * capture_sub.c: capture subtitles
 *****************************************************************************
 * $Id: capture_sub.c,v 1.10 2004/09/08 21:03:46 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2003 Alainjj
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>

#include "vt.h"
#include "misc.h"
#include "fdset.h"
#include "vbi.h"
#include "lang.h"
#include "dllist.h"
#include "export.h"

static struct vbi *vbi = 0;


int subtitles_pgno = -1;
extern int real_alevt_in_use, alevt_in_use;
int sub_alevt_in_use = 0;

static int subno, subtitles_all;
static struct export *fmt;
static char tmpname[] = "/tmp/xdtv_sub_XXXXXX";
extern int do_command_single(char *);
extern int vbifd;
static pthread_t sub_thread;
static int request_sub_stop;
void start_subtitles(void);
void stop_subtitles(void);

static void
event(void * dummy, struct vt_event *ev)
{
  struct vt_page *vtp;

  switch (ev->type) {
  case EV_PAGE:
    vtp = ev->p1;
    if (subtitles_pgno == vtp->pgno || subtitles_all)
      if (subno == ANY_SUB || subno == vtp->subno) {
	int fd ,nr;
	char buf[3031];
	char *cmd;
	export(fmt, vtp, tmpname);
	fd = open(tmpname, O_RDONLY);
	nr = read(fd, buf, 3000);
	if(nr == -1) perror("read");
	if(nr<41) return;
	close(fd);
	unlink(tmpname);
	buf[nr]='\0';
	if(subtitles_all) {
	  char numero[30];
	  sprintf(numero,"(page number=%03x)\n",vtp->pgno);
	  strcat(buf,numero);
	}
	cmd = buf + 82 - 4;
	strncpy(cmd, "vtx ", 4);
	do_command_single(cmd);
	if(vbi->cache)
	  vbi->cache->op->reset(vbi->cache); 
	// is there a way to only remove the cached sub....
      }
  }
}

/* run with Alevt */
void capture_sub_init(struct vbi *v) {
  latin1 = 1;
  vbi = v;
  subno = ANY_SUB;
  fmt = export_open("ascii");
  close(mkstemp(tmpname)); // bad use....
  vbi_add_handler(vbi, event, NULL); // register event handler
}

void capture_sub_stop() {
  vbi_del_handler(vbi, event, NULL);
}

void set_subtitles_pageno(char *pageno) {
  char *end;
  do_command_single("vtx");
  if(pageno == NULL || strcmp(pageno, "none") == 0) {
    subtitles_all = 0;
    subtitles_pgno = -1;
    stop_subtitles();
  }
  else  {
    if(strcmp(pageno, "all") == 0) {
      subtitles_pgno = 0;
      subtitles_all = 1;
    }  else {
      subtitles_pgno = strtol(pageno, &end, 16);  
      subtitles_all = 0;
    }
    if(!(real_alevt_in_use || sub_alevt_in_use))
      start_subtitles();
  }
}


static void * sub_main(void *arg) {
  int ret = 0;
  request_sub_stop = 0;
  memset(&fds, 0, sizeof (struct fdset));
  fdset_init(fds);
  vbi = vbi_open(NULL, NULL, 1, -1);
  capture_sub_init(vbi);
  while (!request_sub_stop) {
    fdset_select(fds, -1);
  }
  pthread_exit(&ret);
}

/* run without Alevt */
void start_subtitles(void) {
  if(subtitles_pgno == -1 || vbifd == -1 || 
     (real_alevt_in_use || sub_alevt_in_use)) return;
  alevt_in_use = 1;
  sub_alevt_in_use = 1;
  pthread_create (&sub_thread, NULL, sub_main, NULL);
}

void stop_subtitles(void) {
  void *ret;
  if(!sub_alevt_in_use) return;
  request_sub_stop = 1;
  pthread_join (sub_thread, &ret);
  alevt_in_use = real_alevt_in_use;
  sub_alevt_in_use = 0;
}



