#!/bin/bash
#
# Copyright (C) 2004 Mr_Moustache, Lille, FRANCE
#
#
# Ce script est bas sur un slackbuild de LiNuCe, Marseille, FRANCE
#
# Ce programme est un logiciel libre. Vous pouvez le redistribuer
# et/ou le modifier sous les termes de la license GNU GPL telle
# qu'elle est publie par la FSF (Free Software Foundation), en
# utilisant la version 2 de cette licence ou, selon votre choix,
# toute autre version plus rcente.

if [ $UID -eq 0 ]; then
    echo "Ne PAS m'excuter en tant que super-utilisateur ROOT !"
    exit 1
fi

set -e -x

### Configuration du SlackBuild ###
source $PWD/build.conf
### Fin de Configuration du SlackBuild ###


cwd=$PWD


# Nettoyage des fichiers temporaires
if [ ! -d "$tmp" ]; then
    mkdir -m 755 -p $tmp
else
    rm -rf $tmp/$name-$version
    rm -rf $pkg
fi

# Decompression des sources
tar xjf $name-$version.tar.bz2 -C $tmp \
|| tar xzf $name-$version.tar.gz -C $tmp

cd $tmp/$name-$version

### Patch des source pour support DESTDIR ###
#patch -p1 <$tmp/xdtv-2.0.0-DESTDIR.patch
## Fin de Patch ###


### Compilation ###
# Variables d'environnements
export LANG=C
export LC_ALL=C
#export CFLAGS="-O2 -march=$arch -mcpu=$cpu"
#export CXXFLAGS="$CFLAGS"

# Configuration
./configure \
    --prefix=/usr \
    --enable-xinerama

# Compilation
make

# Installation
mkdir -m 755 -p $pkg
make DESTDIR=$pkg install
### Fin de Compilation ###


### Documentation ###
docs="AUTHORS ChangeLog COPYING FAQfr-xdtv NEWS TODO"
mkdir -m 755 -p $pkg/usr/doc/$name-$version
install -m 644 $docs $pkg/usr/doc/$name-$version/

find $pkg/usr/man/man1 -name "*.1" -exec gzip -9 {} \;

mkdir -m 755 $pkg/install
install -m 644 $cwd/slack-desc $pkg/install/slack-desc
### Fin de Documentation ###


### Permissions/Stripping ###
# Permissions
pushd $pkg
    find . -type f | xargs chmod 644
    find . -type d | xargs chmod 755
popd
chmod 755 $pkg/usr/bin/*

#Stripping
for file in $(find $pkg/usr/bin -type f | file -f - | grep "executable" | grep "not stripped" | cut -f 1 -d :)
do
    strip --strip-all $file
    chmod 755 $file
done

#for file in $(find $pkg/usr/lib -type f | file -f - | grep "shared object" | grep "not stripped" | cut -f 1 -d :)
#do
#    strip --strip-unneeded $file
#    chmod 755 $file
#done
### Fin de Permissions/Stripping ###


cd $tmp
rm -rf $name-$version
echo "Installation temporaire termine."
echo "Vous pouvez lancer pack.sh en ROOT."
exit 0

