/*****************************************************************************
 * alevtparams_ui.c: AleVT Parameters Xaw GUI
 *****************************************************************************
 * $Id: alevtparams_ui.c,v 1.16 2004/10/17 17:34:46 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2004 Pingus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/AsciiText.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#include "strtab.h"
#include "xdtv.h"
#include "grab.h"
#include "x11.h"
#include "toolbox.h"
#include "popup_ui.h"
#include "alevt.h"

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS 
# include "../pixmaps/alevt_defaultpage.xpm"
# include "../pixmaps/alevt_finetune.xpm"
# include "../pixmaps/alevt_otheralevtparams.xpm"
# include "../pixmaps/alevt_openmainoptions.xpm"
# include "../pixmaps/alevt_startalevt.xpm"
# include "../pixmaps/alevt_applysave.xpm"
#endif
#endif

/*-------------------------------------------------------------------------*/
extern void save_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern void SetBgAction (Widget, XEvent *, String *, Cardinal *);
extern void AleVTAction (Widget, XEvent *, String *, Cardinal *);
extern void OptionsAction (Widget, XEvent *, String *, Cardinal *);
extern void action_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern Widget app_shell, c_alevt;
extern Display *dpy;
extern Atom wm_protocols[2];
extern int debug;
extern int xawpopup;
extern int real_alevt_in_use;

static Widget alevtparams_shell, alevtparams_paned;
static Widget c_finetune_mode;
static Widget c_alevtaction;
static Widget c_openalevt;
static Widget c_error_reduction;
static Widget c_error_bell;
static Widget c_charset;
static Widget t_finetune_str;
static Widget t_defaultpage_str;
static Widget c_defaultpage;
static Widget c_alevtparams;
static Widget c_finetune;
static Widget c_alevtparamssave;

int alevt_finetune_mode;
int alevt_error_reduction;
int alevt_error_bell;
int alevt_charset;
char * alevt_finetune_str = NULL;
char * alevt_defaultpage_str = NULL;

#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif
/*------------------------------------------------------------------------*/

enum {
  ALEVT_FINETUNE_MODE,
  ALEVT_ERROR_REDUCTION,
  ALEVT_ERROR_BELL,
  ALEVT_CHARSET
};

static struct STRTAB yes_no_list[] = {
  {0, "Yes"},
  {1, "No"},
  {-1, NULL}
};

static struct STRTAB auto_manual_list[] = {
  {0, "None"},
  {1, "Auto"},
  {2, "Manual"},
  {-1, NULL}
};

static struct STRTAB charset_list[] = {
  {0,  "latin-1"},
  {1,  "latin-2"},
  {2,  "Cyrillic (Koi8-r)"},
  {3,  "Hellenic (iso8859-7)"},
  {-1, NULL}
};

/*-------------------------------------------------------------------------*/

struct CALL_ACTION call_alevt = { 0, "AleVT", {NULL} };
struct CALL_ACTION call_options_2 = { 0, "Options", {NULL} };

/*--------------------------------------------------------------------------*/

static void
close_alevtparamswin (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  XtCallActionProc (alevtparams_shell, "AleVTParams", NULL, NULL, 0);
}

void
AleVTParamsAction (Widget widget, XEvent * event, String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;

  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Config: wm_save_yourself\n");
          XSetCommand (XtDisplay (alevtparams_shell), XtWindow (alevtparams_shell), NULL, 0);
          return;
        }
    }

  if (alevtparams_shell == NULL)
    {
      fprintf(stderr, "AleVTParamsAction: ooops: alevtparams_shell is NULL\n");
      if (xawpopup)
        PopupMessage("AleVTParamsAction:\nooops: alevtparams_shell is NULL\n");

      return;
    }

  if(real_alevt_in_use == 1)
    {
      fprintf(stderr, "AleVTParamsAction: Can't modify any options if AleVT is active\n");
      if (xawpopup)
        PopupMessage("Can't modify any options if AleVT is active\n");
      return;
    }

  if (mapped)
    {
      XtPopdown (alevtparams_shell);
      mapped = 0;
      if (c_alevt)
        XtVaSetValues (c_alevt, XtNlabel, "Teletext (AleVT) :     (Off)     Ctrl+A", NULL); 
    }
  else
    {
      XtPopup (alevtparams_shell, XtGrabNone);
      mapped = 1;
      if (c_alevt)
        XtVaSetValues (c_alevt, XtNlabel, "Teletext (AleVT) : (Options)      Alt+A", NULL);   
      if (first)
        {
          XSetWMProtocols (XtDisplay (alevtparams_shell), XtWindow (alevtparams_shell), wm_protocols, 2);
          first = 0;
        }
    }
}

/*-------------------------------------------------------------------------*/

static void
alevtparams_menu_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  int cd = (int) clientdata;
  int j;
  char label[64];
  char *tok;
  int argc;

  switch (cd)
    {
    case ALEVT_FINETUNE_MODE:
      if (-1 != (j = popup_menu (widget, "Finetune Mode", auto_manual_list)))
        {
          alevt_finetune_mode = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s:       %s", "Finetune Mode",
                   int_to_str (alevt_finetune_mode, auto_manual_list));
          XtVaSetValues (c_finetune_mode, XtNlabel, label, NULL);
          if (debug)
	    fprintf(stderr,"Finetune mode: %d\n",alevt_finetune_mode);

      if (int_to_str (alevt_finetune_mode, auto_manual_list) == "Auto" || int_to_str (alevt_finetune_mode, auto_manual_list) == "None")
      {
	XtVaSetValues(t_finetune_str, XtNsensitive, False, NULL);
        tok = "gray95";
	argc = 1;
	SetBgAction (t_finetune_str, NULL, &tok, &argc);
      }
      else
      {
        XtVaSetValues(t_finetune_str, XtNsensitive, True, NULL);
        tok = "white";
	argc = 1;
	SetBgAction (t_finetune_str, NULL, &tok, &argc);
      }
        }
      break;

    case ALEVT_ERROR_REDUCTION:
      if (-1 != (j = popup_menu (widget, "Error Reduction", yes_no_list)))
        {
          alevt_error_reduction = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Error Reduction",
                   int_to_str (alevt_error_reduction, yes_no_list));
          XtVaSetValues (c_error_reduction, XtNlabel, label, NULL);
	  fprintf(stderr,"Error Reduction: %d\n",alevt_error_reduction);
        }
      break;

    case ALEVT_ERROR_BELL:
      if (-1 != (j = popup_menu (widget, "Error Bell", yes_no_list)))
        {
          alevt_error_bell = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Error Bell",
                   int_to_str (alevt_error_bell, yes_no_list));
          XtVaSetValues (c_error_bell, XtNlabel, label, NULL);
	  fprintf(stderr,"Error Bell: %d\n",alevt_error_bell);
        }
      break;

    case ALEVT_CHARSET:
      if (-1 != (j = popup_menu (widget, "Character Set", charset_list)))
        {
          alevt_charset = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Character Set",
                   int_to_str (alevt_charset, charset_list));
          XtVaSetValues (c_charset, XtNlabel, label, NULL);
	  fprintf(stderr,"Character Set: %d\n",alevt_charset);
        }
      break;

    default:
      break;
    }
}


/*--------------------------------------------------------------------------*/

void
create_alevtparamswin()
{
  Widget c;
  char label[64];

  alevtparams_shell = XtVaAppCreateShell ("AleVTParams", "XdTV",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell, XtNvisual,vinfo->visual,
				   XtNcolormap,colormap, XtNdepth,vinfo->depth,
				   NULL);

  alevtparams_paned =
    XtVaCreateManagedWidget ("paned", panedWidgetClass, alevtparams_shell, NULL);

  /* Default Page Label */
  c_defaultpage = XtVaCreateManagedWidget ("ldefaultpage", labelWidgetClass, alevtparams_paned,
                           PANED_FIX, NULL);

  t_defaultpage_str = c = XtVaCreateManagedWidget ("defaultpage", asciiTextWidgetClass, alevtparams_paned,
                                                PANED_FIX, NULL);
  if (alevt_defaultpage_str == NULL || strcmp(alevt_defaultpage_str,"(null)") == 0) alevt_defaultpage_str = "100";
    XtVaSetValues (t_defaultpage_str, XtNstring, alevt_defaultpage_str, NULL);

  /* Finetune Method Label */
  c_finetune = XtVaCreateManagedWidget ("lfinetune", labelWidgetClass, alevtparams_paned,
                           PANED_FIX, NULL);

  /* FineTune Menu */
  c_finetune_mode = c = XtVaCreateManagedWidget ("finetune", commandWidgetClass, alevtparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, alevtparams_menu_cb, (XtPointer) ALEVT_FINETUNE_MODE);
  sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Finetune Mode",
                   int_to_str (alevt_finetune_mode, auto_manual_list));
  XtVaSetValues (c, XtNlabel, label, NULL);

  t_finetune_str = c = XtVaCreateManagedWidget ("finetune_val", asciiTextWidgetClass, alevtparams_paned,
                                                PANED_FIX, NULL);
  if (alevt_finetune_str == NULL || strcmp(alevt_finetune_str,"(null)") == 0) alevt_finetune_str = "1";
    XtVaSetValues (t_finetune_str, XtNstring, alevt_finetune_str, NULL);
  if (int_to_str (alevt_finetune_mode, auto_manual_list) == "Auto" || int_to_str (alevt_finetune_mode, auto_manual_list) == "None")
    XtVaSetValues(t_finetune_str, XtNsensitive, False, NULL);


    /* Other AleVT Parameters Label */
  c_alevtparams = XtVaCreateManagedWidget ("lalevtparams", labelWidgetClass, alevtparams_paned,
                           PANED_FIX, NULL);

  /* Error Reduction Menu */
  c_error_reduction = c = XtVaCreateManagedWidget ("error_reduction", commandWidgetClass, alevtparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, alevtparams_menu_cb, (XtPointer) ALEVT_ERROR_REDUCTION);
  sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Error Reduction",
           int_to_str (alevt_error_reduction, yes_no_list));
  XtVaSetValues (c, XtNlabel, label, NULL);

  /* Error Bell Menu */
  c_error_bell = c = XtVaCreateManagedWidget ("error_bell", commandWidgetClass, alevtparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, alevtparams_menu_cb, (XtPointer) ALEVT_ERROR_BELL);
  sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Error Bell",
           int_to_str (alevt_error_bell, yes_no_list));
  XtVaSetValues (c, XtNlabel, label, NULL);

  /* Character Set Menu */
  c_charset = c = XtVaCreateManagedWidget ("charset", commandWidgetClass, alevtparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, alevtparams_menu_cb, (XtPointer) ALEVT_CHARSET);
  sprintf (label, "%-" LABEL_WIDTH3 "s:     %s", "Character Set",
           int_to_str (alevt_charset, charset_list));
  XtVaSetValues (c, XtNlabel, label, NULL);

  
/* launch AleVT Action */
  c_alevtaction = c = XtVaCreateManagedWidget ("lalevt", commandWidgetClass, alevtparams_paned, PANED_FIX, NULL);
    XtAddCallback (c, XtNcallback, save_cb, (XtPointer) NULL);
    XtAddCallback (c, XtNcallback, close_alevtparamswin, (XtPointer) NULL);    
    XtAddCallback (c, XtNcallback, action_cb, (XtPointer) & call_alevt);   

    
/* Open Main Options Menu */
  c_openalevt = c = XtVaCreateManagedWidget ("lopenmain", commandWidgetClass, alevtparams_paned, PANED_FIX, NULL); 
    XtAddCallback (c, XtNcallback, action_cb, (XtPointer) & call_options_2);        

/* Button to close Subtitle Page Menu */

  c_alevtparamssave = c = XtVaCreateManagedWidget ("lalevtparamssave", commandWidgetClass, alevtparams_paned, PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, save_cb, (XtPointer) NULL);
  XtAddCallback (c, XtNcallback, close_alevtparamswin, (XtPointer) NULL);


#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(alevtparams_shell),
                          RootWindowOfScreen(XtScreen(alevtparams_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(alevtparams_shell, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS   
  XpmCreatePixmapFromData(XtDisplay(alevtparams_paned),
                          RootWindowOfScreen(XtScreen(alevtparams_paned)),
                          alevt_defaultpage_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_defaultpage, XtNbitmap, icon_pixmap, NULL); 

  XpmCreatePixmapFromData(XtDisplay(alevtparams_paned),
                          RootWindowOfScreen(XtScreen(alevtparams_paned)),
                          alevt_finetune_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_finetune, XtNbitmap, icon_pixmap, NULL); 
  
  XpmCreatePixmapFromData(XtDisplay(alevtparams_paned),
                          RootWindowOfScreen(XtScreen(alevtparams_paned)),
                          alevt_otheralevtparams_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_alevtparams, XtNbitmap, icon_pixmap, NULL); 
  
  XpmCreatePixmapFromData(XtDisplay(alevtparams_paned),
                          RootWindowOfScreen(XtScreen(alevtparams_paned)),
                          alevt_openmainoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_openalevt, XtNbitmap, icon_pixmap, NULL);   
  
  XpmCreatePixmapFromData(XtDisplay(alevtparams_paned),
                          RootWindowOfScreen(XtScreen(alevtparams_paned)),
                          alevt_startalevt_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_alevtaction, XtNbitmap, icon_pixmap, NULL);  
  
  XpmCreatePixmapFromData(XtDisplay(alevtparams_paned),
                          RootWindowOfScreen(XtScreen(alevtparams_paned)),
                          alevt_applysave_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_alevtparamssave, XtNbitmap, icon_pixmap, NULL);      
#endif
#endif
  
}

void update_defaultpage(void)
{
  if(t_defaultpage_str)
    XtVaGetValues (t_defaultpage_str, XtNstring, &alevt_defaultpage_str, NULL);
}

void update_finetune(void)
{
  if(t_finetune_str)
    XtVaGetValues (t_finetune_str, XtNstring, &alevt_finetune_str, NULL);
}
