/*****************************************************************************
 * $Id: blackborder.c,v 1.8 2004/09/13 20:29:23 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <stdlib.h>

#include "config.h"
#include "channel.h"
#include "blackborder.h"
#include "commands.h"
#include "divx.h"

void update_blackborder(void);

static int ybar_ratio = 0;

static inline int scale (int l, int lold, int lnew) {
  return (l * lnew + (lold>>1)) / lold;
}

int get_ybar(int height) {
  return scale(get_ybar_ratio(), YBAR_DEN, height);
}

int get_ybar_ratio(void) {
  return ybar_ratio;
}

void set_ybar_ratio(int y) {
  if (is_divx_in_progress()) return;
  if(y<0 || y> YBAR_DEN/2) return;
  ybar_ratio = y;
  update_blackborder();
}
