/*****************************************************************************
 * file.c: misc file checking functions
 *****************************************************************************
 * $Id: file.c,v 1.7 2004/09/18 08:15:09 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "config.h"
#include "file.h"

char user_dir[255];

static int copy(char *file1, char *file2) {
  char buf[1024];
  int r, d1, d2;
  if((d1=open(file1,O_RDONLY))<0) {perror("openr"); return -1;}
  if((d2=open(file2,O_WRONLY|O_TRUNC|O_CREAT,S_IRUSR|S_IWUSR))<0)
    {perror("openw"); close(d1); return -1; }
  do {
    if((r=read(d1,buf,1024))<0) {perror("read");close(d1);close(d2); return -1;}
    if(write(d2,buf,r)<0) { perror("write");close(d1);close(d2); return -1;}
  }
  while(r>0);
  close(d1);
  close(d2);
  return 0;
} 


void check_user_directory (void) {
  struct stat buf;
  int have_to_create = 0;

  sprintf (user_dir, "%s/.xdtv", getenv ("HOME"));
  
  if (stat (user_dir, &buf) == 0)  {
    if (! S_ISDIR (buf.st_mode))  {
      unlink(user_dir);
      have_to_create = 1;
    }
  } else
    have_to_create = 1;

  if(have_to_create) {
    char file1[255], file2[255];
    fprintf (stderr,
	     "Warning: xdtv user directory does not exist, I'm creating it.\n");
    if (mkdir (user_dir, S_IRWXU) != 0) {
      fprintf (stderr,
	       "Error (not fatal): coud not create xdtv user directory\n");
      return;
    }
#if 1 // to remove for not copying old config files...
    sprintf (file1, "%s/.xawdecode/xawdecoderc", getenv ("HOME"));
    sprintf (file2, "%s/xdtvrc", user_dir);
    if (stat (file1, &buf) == 0)  {
      fprintf(stderr, "copying %s in %s\n", file1, file2);
      if(copy(file1,file2)<0)
	fprintf (stderr, "Error (not fatal): copy failed\n");
    }
#endif
  }
}
