/*****************************************************************************
 * file_sel.c: a file selector in xaw
 *****************************************************************************
 * $Id: file_sel.c,v 1.3 2004/11/13 12:09:21 pingus77 Exp $
 *****************************************************************************
 *
 * Adapted by Pingus 2004
 *
 *****************************************************************************
 *
 * Copyright (C) 1994/09/06 by Nobuyuki Maruichi
 * From mwxcd 1.32
 *
 * Adviced by S.Kouno
 * from ggxsnd (snd_file.c) 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/TextSrc.h>
#include <X11/Xaw/TextSink.h>
#include <X11/Xaw/AsciiSrc.h>
#include <X11/Xaw/AsciiSink.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include "file_sel.h"
#include "xfile.h"
#include "config.h"

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#ifdef HAVE_XPM
#ifdef HAVE_PIXMAPS 
#include "../pixmaps/browse_file.xpm"
#include "../pixmaps/browse_folder.xpm"
#include "../pixmaps/browse_done.xpm"
#include "../pixmaps/browse_cancel.xpm"
#include "../pixmaps/browse_selector.xpm"
#endif
#endif

#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif

Widget pFileShell, fileSelectorDialog;
Widget fileSelectorView, fileSelectorList;
Widget fileSelectorDir;

extern char *filePickup;
extern char *wildCard;
extern int (*sort_comp)(const void *file1, const void *file2);
extern Atom wm_protocols[2];

void setPickup(Widget w, XtPointer client_data, XtPointer call_data);
void selectorPane(Widget w, XtPointer client_data, XtPointer call_data);
static void (*SelectFinish)(const char *dirName, const char *fileName);

void setSortFunc(Widget w, XtPointer client_data, XtPointer call_data);

FileSelctorInfo fileSelecterInfo;
static PopdownInfo filePopdownInfo;

// Pixmap mark;

struct menu_data fileMenuInfo[] = {
	{TypeSmeLine, "fileMenuTopLine", NULL, NULL},
	{TypeSmeBSB,  "allFile",	 NULL, selectorPane}, 
	{TypeSmeBSB,  "aviFileOnly",	 NULL, selectorPane}, 
	{TypeSmeBSB,  "jpegFileOnly",	 NULL, selectorPane},
	{TypeSmeBSB,  "ppmFileOnly",	 NULL, selectorPane}, 
	{TypeSmeLine, "fileMenuLine",	 NULL, NULL},
	{TypeSmeBSB,  "nonSort",	 NULL, selectorPane},
	{TypeSmeBSB,  "asciiSort",	 NULL, selectorPane},
	{TypeSmeBSB,  "suffixSort",	 NULL, selectorPane},
	{TypeSmeBSB,  "dateSort",	 NULL, selectorPane},
	{TypeSmeBSB,  "sizeSort",	 NULL, selectorPane},
	{EOF, NULL, NULL, NULL}
};


struct menuData fileMenus = {
	NULL,
	NULL,
	"fileMenu", 
	sizeof(fileMenuInfo) / sizeof(fileMenuInfo[0]) - 1,
	NULL, 
	NULL, 
	fileMenuInfo
};


struct menu_data *fileSelectors[] = {
	&fileMenuInfo[1], &fileMenuInfo[2], 
	&fileMenuInfo[3], &fileMenuInfo[4], NULL
};


selectorPanes filePickupPaneInfo[] = {
	{ 0, fileSelectors, &fileSelecterInfo, setPickup, NULL}, 
	{ 1, fileSelectors, &fileSelecterInfo, setPickup, "*.avi"},
	{ 2, fileSelectors, &fileSelecterInfo, setPickup, "*.jpeg"},
	{ 3, fileSelectors, &fileSelecterInfo, setPickup, "*.ppm"},
	{ EOF, NULL, NULL, NULL, NULL}
};


struct menu_data *fileSortSelectors[] = {
	&fileMenuInfo[6], &fileMenuInfo[7], &fileMenuInfo[8],
	&fileMenuInfo[9], &fileMenuInfo[10], NULL
};


selectorPanes fileSortPaneInfo[] = {
	{ 0, fileSortSelectors, &fileSelecterInfo, setSortFunc, NULL}, 
	{ 1, fileSortSelectors, &fileSelecterInfo, setSortFunc, ascii_comp}, 
	{ 2, fileSortSelectors, &fileSelecterInfo, setSortFunc, suffix_comp}, 
	{ 3, fileSortSelectors, &fileSelecterInfo, setSortFunc, date_comp}, 
	{ 4, fileSortSelectors, &fileSelecterInfo, setSortFunc, size_comp}, 
	{ EOF, NULL, NULL, NULL, NULL}
};

int (*compire_func)(const void *, const void *) = NULL;


int isDirectory(const char *filename)
{
	int status = False;
	struct stat sbuf;

	stat(filename, &sbuf);
	switch(sbuf.st_mode & S_IFMT) {
	case S_IFLNK:
	case S_IFDIR:
		status = True;
		break;
	case S_IFREG:
		break;
	}
	return(status);
}


const char *fileNaming(const char *filename)
{
	int counter;

	counter = strlen(filename);
	while(counter > 0 && *(filename + counter - (counter > 0)) != '/')
		--counter;
	return(filename + counter);
}


int fileCheck(const char *filepath, int dirLength, char *dirName, int fileLength, char *fileName)
{
	int counter;
	int result;
	char *separate_ptr;
	char fnameBuffer[8192];

	counter = strlen(filepath);
	if(*(filepath + counter - (counter > 0)) == '/')
		--counter;
	if(counter >= sizeof(fnameBuffer))
		counter = sizeof(fnameBuffer) - 1;
	sprintf(fnameBuffer, "%.*s", counter, filepath);
	separate_ptr = fnameBuffer+counter;
	while(isDirectory(fnameBuffer) == FALSE && separate_ptr != NULL) {
		separate_ptr = strrchr(fnameBuffer, '/');
		if(separate_ptr != NULL) {
			*separate_ptr = '\0';
		}
	}
	result = (strlen(fnameBuffer) < dirLength);
	sprintf( dirName, "%.*s",  dirLength - 1, fnameBuffer);
	if(separate_ptr != NULL) {
		counter = separate_ptr - fnameBuffer + 1;
		sprintf(fileName, "%.*s", fileLength - 1, filepath + counter);
		result = (strlen(filepath + counter) < fileLength);
	}
	return(result);
}


void multiPopupDialog(Widget w, XtPointer client_data, XtPointer call_data)
{
	PopdownInfo *popdownData = (PopdownInfo*)client_data;
	Position x, y;
	Dimension width, height;

	XtVaGetValues(XtParent(popdownData->popupWidget), 
			XtNwidth, &width,
			XtNheight, &height,
			NULL);
	
	XtTranslateCoords(XtParent(popdownData->popupWidget),	/* Widget */
			(Position) width/2,			/* x */
			(Position) height/2,			/* y */
			&x, &y);				/* coords on root window */

	XtVaSetValues(popdownData->popdownShell, 
			XtNx, x,
			XtNy, y,
			NULL);

	XtPopup(popdownData->popdownShell, XtGrabExclusive);
}


void fileSelectorEnd(Widget w, XtPointer client_data, XtPointer call_data)
{
	String filename;
	PopdownInfo *popdownData = (PopdownInfo*)client_data;

	/*filename = XawDialogGetValueString((Widget)popdownData->client_data);*/
	XtVaGetValues((Widget)popdownData->client_data, XtNstring, &filename, NULL);
	if(SelectFinish != NULL)
		SelectFinish(fileSelecterInfo.searchingPath, filename);
}


void fileDialogDone(Widget w, XtPointer client_data, XtPointer call_data)
{
	String string;
	PopdownInfo *popdownData = (PopdownInfo*)client_data;

	XtPopdown(popdownData->popdownShell);
	XtSetSensitive(popdownData->popupWidget, TRUE);

	/*string = XawDialogGetValueString((Widget)popdownData->client_data);*/
	XtVaGetValues((Widget)popdownData->client_data, XtNstring, &string, NULL);
	/* printf("Dialog = \"%s\"\n", string); */
}



static void RecallAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Widget target = NULL;
	String *localParams = params;
	Cardinal localNumParams = *num_params;
	String actionString;
	
	switch((int)localNumParams) 
	{
	default:
	target = XtNameToWidget(pFileShell, *localParams);
	++localParams;
	--localNumParams;
	break;
	
	case 0:
	case 1:
		XtWarning("Parameter Error: recall action table.");
		break;
	}

	if(target != NULL) {
		actionString = *localParams;
		++localParams;
		--localNumParams;
		XtCallActionProc(target, actionString, event, localParams, localNumParams);
	} else {
		printf("recall:target not found.\n");
	}
}


void file_chd(Widget w, XtPointer client_data, XtPointer call_data)
{
	chdir(fileSelecterInfo.searchingPath);
}


void paneMarkClaer(struct menuData *menuInfo)
{
	int i;
	int numOfMenuItems;

	numOfMenuItems = menuInfo->num;

	for (i = 0; i < numOfMenuItems; i++) {
		switch(menuInfo->info[i].type) {
		case TypeSmeBSB:
			XtVaSetValues(menuInfo->info[i].myWidget, XtNleftBitmap, None, NULL);
			break;
		default:
			break;
		}
	}
}


int paneTypeCount(const struct menu_data *menuInfo, int type)
{
	int counter;

	counter = 0;
	while((menuInfo + counter)->type == type)
		++counter;
	return(counter);
}


int paneSequenceTypeCount(const struct menu_data *menuInfo, int type)
{
	int counter = 0;

	while(menuInfo->type != EOF) {
		while(menuInfo->type != type && menuInfo->type != EOF)
			++menuInfo;

		if(menuInfo->type == type) {
			while(menuInfo->type == type)
				++menuInfo;
			++counter;
		}
	}
	return(counter);
}


void menuSelectorPanes(Widget w, XtPointer client_data, XtPointer call_data)
{
	int counter;
	selectorPanes *info = (selectorPanes*) client_data;
	//extern Pixmap mark;

	if(info->option != NULL)
		info->option(w, client_data,  call_data);
	
	for(counter = 0;*(info->panesInfo + counter) != NULL;++counter) {
		if(counter == info->paneNo) {
			XtVaSetValues((*(info->panesInfo + counter))->myWidget, XtNleftBitmap, None/*mark*/, NULL);
		} else {
			XtVaSetValues((*(info->panesInfo + counter))->myWidget, XtNleftBitmap, None, NULL);
		}
	}
	remakeFilePickup(info->fileSelecterInfo);
}


void setPickup(Widget w, XtPointer client_data, XtPointer call_data)
{
	selectorPanes *info = (selectorPanes*) client_data;

	if(info->client_data != NULL)
		filePickup = (char*)info->client_data;
	else
		filePickup = NULL;
}


void setSortFunc(Widget w, XtPointer client_data, XtPointer call_data)
{
	selectorPanes *info = (selectorPanes*) client_data;

	if(info->client_data != NULL)
		sort_comp = (int (*)(const void *, const void *))info->client_data;
	else
		sort_comp = NULL;
}


void selectorPane(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct menu_data *info = (struct menu_data*) client_data;
	//extern Pixmap mark;

	XtVaSetValues(info->myWidget, XtNleftBitmap, None/*mark*/, NULL);
}


static void MenuSelect(Widget w, XtPointer client_data, XtPointer garbage)
{
	struct menu_data *info = (struct menu_data*) client_data;

	/* printf("Menu item %s has been selected.\n", XtName(w)); */
	if (info->function != NULL) {
		info->function(w, client_data, NULL);
	}
}


void makeMenus(Widget parent, struct menuData *menuInfo)
{
	int i;
	int numOfMenuItems;
	char name_buffer[20];
	Widget entry = NULL;

	numOfMenuItems = menuInfo->num;
	/* printf("Menu Items = %d.\n", numOfMenuItems); */

	sprintf(name_buffer, "%sButton", menuInfo->menuName);
	menuInfo->menuButton = XtVaCreateManagedWidget(
						name_buffer, 
						menuButtonWidgetClass, 
						parent,
						XtNmenuName, menuInfo->menuName, 
						NULL);
	menuInfo->menu = 
			XtCreatePopupShell(menuInfo->menuName, 
					simpleMenuWidgetClass, menuInfo->menuButton, NULL, 0);
					
	#ifdef HAVE_XPM
	#ifdef HAVE_PIXMAPS 
  		XpmCreatePixmapFromData(XtDisplay(parent),
                          RootWindowOfScreen(XtScreen(parent)),
                          browse_selector_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(menuInfo->menuButton, XtNbitmap, icon_pixmap, NULL);
	#endif
	#endif	
	
	if(menuInfo->popup != NULL) {
		XtAddCallback(menuInfo->menu, XtNpopupCallback, 
							menuInfo->popup, (XtPointer)menuInfo);
	}
	if(menuInfo->popdown != NULL) {
		XtAddCallback(menuInfo->menu, XtNpopdownCallback, 
							menuInfo->popdown, (XtPointer)menuInfo);
	}

	for (i = 0; i < numOfMenuItems; i++) {
		switch(menuInfo->info[i].type) {
		case TypeSme:
			entry = XtCreateManagedWidget(menuInfo->info[i].widgetName, 
							smeObjectClass, menuInfo->menu, NULL, 0);
			break;
		case TypeSmeLine:
			entry = XtCreateManagedWidget(menuInfo->info[i].widgetName,
							smeLineObjectClass, menuInfo->menu, NULL, 0);
			break;
		case TypeSmeBSB:
			entry = XtCreateManagedWidget(menuInfo->info[i].widgetName, 
							smeBSBObjectClass, menuInfo->menu, NULL, 0);
			XtAddCallback(entry, XtNcallback, 
							MenuSelect, (XtPointer)&menuInfo->info[i]);
			break;
		default:
			break;
		}
		menuInfo->info[i].myWidget = entry;
	}
}


Widget fileDialogInit(Widget parent)
{
	Widget fileSelectorDialogDone, fileSelectorCancel, fileSelectorFilename;
	Widget fileSelectorFilelabel, fileSelectorDirlabel;
	Widget fileSelectorArea, fileSelectorMenuArea;
	static XtActionsRec fileSelectorActions[] = {
		{"recall", RecallAction}
	};

	XtAppAddActions(XtWidgetToApplicationContext(parent), 
						fileSelectorActions, XtNumber(fileSelectorActions));
	pFileShell = XtCreatePopupShell(
			"pFileShell",
			transientShellWidgetClass,
			parent,
			NULL,
			0
			);

	fileSelectorArea = XtVaCreateManagedWidget(
			"fileSelectorArea", 		/* arbitrary widget name */
			panedWidgetClass,		/* widget class from Form.h */
			pFileShell,	 		/* parent widget */
			NULL);				/* tarminate varargs list */

	fileSelectorMenuArea = XtVaCreateManagedWidget(
			"fileSelectorMenuArea", 	/* arbitrary widget name */
			boxWidgetClass,			/* widget class from Form.h */
			fileSelectorArea,	 	/* parent widget */
			NULL);				/* tarminate varargs list */	

	makeMenus(fileSelectorMenuArea, &fileMenus);
	paneMarkClaer(&fileMenus);
	XtAddCallback((fileMenus.info+1)->myWidget, 
				XtNcallback, menuSelectorPanes, &filePickupPaneInfo[0]);
	XtAddCallback((fileMenus.info+2)->myWidget, 
				XtNcallback, menuSelectorPanes, &filePickupPaneInfo[1]);
	XtAddCallback((fileMenus.info+3)->myWidget, 
				XtNcallback, menuSelectorPanes, &filePickupPaneInfo[2]);
	XtAddCallback((fileMenus.info+4)->myWidget, 
				XtNcallback, menuSelectorPanes, &filePickupPaneInfo[3]);
	selectorPane((fileMenus.info+1)->myWidget, fileMenus.info+1, NULL);
	selectorPane((fileMenus.info+1)->myWidget, fileMenus.info+1, NULL);

	XtAddCallback((fileMenus.info+6)->myWidget, 
				XtNcallback, menuSelectorPanes, &fileSortPaneInfo[0]);
	XtAddCallback((fileMenus.info+7)->myWidget, 
				XtNcallback, menuSelectorPanes, &fileSortPaneInfo[1]);
	XtAddCallback((fileMenus.info+8)->myWidget, 
				XtNcallback, menuSelectorPanes, &fileSortPaneInfo[2]);
	XtAddCallback((fileMenus.info+9)->myWidget, 
				XtNcallback, menuSelectorPanes, &fileSortPaneInfo[3]);
	XtAddCallback((fileMenus.info+10)->myWidget, 
				XtNcallback, menuSelectorPanes, &fileSortPaneInfo[4]);
	selectorPane((fileMenus.info+7)->myWidget, fileMenus.info+7, NULL);

	fileSelectorDialog = XtCreateManagedWidget(
			"fileSelectorDialog", 		/* widget name   */
			formWidgetClass, 		/* widget class */
			fileSelectorArea, 		/* parent widget*/
			NULL,				/* argument list*/
			0 				/* arglist size */
			);

	fileSelectorFilelabel = XtVaCreateManagedWidget(
			"fileSelectorFilelabel", 	/* widget name   */
			labelWidgetClass, 		/* widget class */
			fileSelectorDialog, 		/* parent widget */
			NULL 				/* argument list */
			);

	fileSelectorDirlabel = XtVaCreateManagedWidget(
			"fileSelectorDirlabel", 	/* widget name   */
			labelWidgetClass, 		/* widget class */
			fileSelectorDialog, 		/* parent widget */
			NULL 				/* argument list */
			);

	fileSelecterInfo.dirWidget = 
		XtVaCreateManagedWidget(
			"fileSelectorDir", 		/* widget name   */
			labelWidgetClass, 		/* widget class */
			fileSelectorDialog, 		/* parent widget */
			NULL 				/* argument list */
			);

	fileSelecterInfo.fileWidget = 
	fileSelectorFilename = XtVaCreateManagedWidget(
			"fileSelectorFilename", 	/* widget name   */
			asciiTextWidgetClass, 		/* widget class */
			fileSelectorDialog, 		/* parent widget */
			XtNeditType, XawtextEdit,
			XtNtype,	XawAsciiString,	
			NULL 				/* argument list */
			);

	fileSelectorDialogDone = XtCreateManagedWidget(
			"fileSelectorDialogDone", 	/* widget name   */
			commandWidgetClass, 		/* widget class */
			fileSelectorDialog, 		/* parent widget*/
			NULL, 				/* argument list*/
			0				/* arglist size */
			);

	fileSelectorCancel = XtCreateManagedWidget(
			"fileSelectorCancel", 		/* widget name   */
			commandWidgetClass, 		/* widget class */
			fileSelectorDialog, 		/* parent widget*/
			NULL, 				/* argument list*/
			0				/* arglist size */
			);			
			
			
	fileSelectorView = XtVaCreateManagedWidget(
			"fileSelectorView", 		/* widget name   */
			viewportWidgetClass, 		/* widget class */
			fileSelectorDialog,	 	/* parent widget */
			XtNallowVert, TRUE, 		/*  */
			NULL 				/* argument list */
			);
	
	fileSelecterInfo.listWidget = 
		XtVaCreateManagedWidget(
			"fileSelectorList", 		/* widget name   */
			listWidgetClass, 		/* widget class */
			fileSelectorView, 		/* parent widget */
			NULL 				/* argument list */
			);

	#ifdef HAVE_XPM
	#ifdef HAVE_PIXMAPS 
  		XpmCreatePixmapFromData(XtDisplay(pFileShell),
                          RootWindowOfScreen(XtScreen(pFileShell)),
                          browse_file_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(fileSelectorFilelabel, XtNbitmap, icon_pixmap, NULL);      
		
  		XpmCreatePixmapFromData(XtDisplay(pFileShell),
                          RootWindowOfScreen(XtScreen(pFileShell)),
                          browse_folder_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(fileSelectorDirlabel, XtNbitmap, icon_pixmap, NULL);
		
  		XpmCreatePixmapFromData(XtDisplay(pFileShell),
                          RootWindowOfScreen(XtScreen(pFileShell)),
                          browse_done_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(fileSelectorDialogDone, XtNbitmap, icon_pixmap, NULL);

  		XpmCreatePixmapFromData(XtDisplay(pFileShell),
                          RootWindowOfScreen(XtScreen(pFileShell)),
                          browse_cancel_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(fileSelectorCancel, XtNbitmap, icon_pixmap, NULL);
	#endif
	#endif

	fileSelecterInfo.searchingPath = getcwd(NULL, 0);
	/*remakeFileSelector(&fileSelecterInfo);*/
	/*filePopdownInfo.popupWidget  = popupButton;*/
	filePopdownInfo.popdownShell = pFileShell;
	filePopdownInfo.client_data  = (XtPointer)fileSelectorFilename;
	XtAddCallback(fileSelecterInfo.listWidget, XtNcallback, 
					 fileListSelect, &fileSelecterInfo);
	XtAddCallback(fileSelectorDialogDone, 
				XtNcallback, fileDialogDone, &filePopdownInfo);
	XtAddCallback(fileSelectorDialogDone, 
				XtNcallback, fileSelectorEnd, &filePopdownInfo);
	XtAddCallback(fileSelectorCancel, 
				XtNcallback, fileDialogDone, &filePopdownInfo);		
	return(pFileShell);
}


void fileSelectorCall(Widget popupButton, const char *dirName, 
			selectorPanes *selectorPane, selectorPanes *sortPane, 
			void (*selectFinish)(const char *dirName, const char *fileName))
{
	menuSelectorPanes(NULL, selectorPane, NULL);
	menuSelectorPanes(NULL, sortPane, NULL);
	chdir(dirName);
	fileSelecterInfo.searchingPath = getcwd(NULL, 0);
	remakeFileSelector(&fileSelecterInfo);
	filePopdownInfo.popupWidget  = popupButton;
	SelectFinish = selectFinish;
	multiPopupDialog(popupButton, &filePopdownInfo, NULL);
	XSetWMProtocols (XtDisplay (pFileShell), XtWindow (pFileShell), wm_protocols, 2);	
}

void
Hidefilesel (Widget widget, XEvent * event,
         String * params, Cardinal * num_params)
{
  XtPopdown(pFileShell);
}
