/*****************************************************************************
 * grab-xv.c: XVideo interface
 *****************************************************************************
 * $Id: grab-xv.c,v 1.7 2004/09/05 06:11:54 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2003 Alainjj
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * With this grabber, it is the X server which communicates
 * with the TV card, by the Xvideo extension. (needs XFree86 >= 4.0)
 * ref: "man v4l" to make your X-server recognize your card.
 *
 *****************************************************************************/


#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#ifdef HAVE_V4L
#include "videodev.h"
#endif

#include "config.h"
#include "strtab.h"
#include "grab.h"
#include "x11.h"

#ifdef HAVE_VIDEO_XV
#include <X11/extensions/Xv.h>
#include <X11/extensions/Xvlib.h>

extern struct GRABBER grab_dummy,grab_xv;
static int grab_audio (int mute, int volume, int *mode);

extern XvEncodingInfo *xv_video_encodings;
extern int xv_video_encodings_n;

#define MAX_NORMS 20
#define MAX_INPUTS 20
#define SEPARATOR '-'

static struct STRTAB *encodings=NULL;


static void free_strtab(struct STRTAB *tab) {
  int i;
  for (i = 0; tab[i].str != NULL; i++)
    free(tab[i].str);
  free(tab);
}

static int
grab_open(struct device_t *device)
{
  int inorms,iinputs,i,dontcut;
  char *norm,*input;
  static struct STRTAB *inputs,*norms;

  if(!have_video_xv) return -1;
  
  encodings = (struct STRTAB *) 
    malloc((xv_video_encodings_n+1)*sizeof(struct STRTAB));
  norms=malloc((MAX_NORMS+1)*sizeof(struct STRTAB));
  inputs=malloc((MAX_INPUTS+1)*sizeof(struct STRTAB));
  inputs[0].str=norms[0].str=NULL;

  dontcut=0;
  for(i=0,inorms=0,iinputs=0; i< xv_video_encodings_n;i++) {
    encodings[i].nr=xv_video_encodings[i].encoding_id;
    encodings[i].str=strdup(xv_video_encodings[i].name);
    norm = encodings[i].str;
    input= index(norm,SEPARATOR);
    if(input != NULL) *input='\0';
    if(str_to_int(norm,norms)==-1 && inorms<MAX_NORMS) {
      norms[inorms].nr=inorms;
      norms[inorms].str=strdup(norm);
      norms[++inorms].str=NULL;
    }
    if(input != NULL) {
      *(input++)=SEPARATOR;
      if(str_to_int(input,inputs)==-1 && iinputs<MAX_INPUTS) {
	inputs[iinputs].nr=iinputs;
	inputs[iinputs].str=strdup(input);
	inputs[++iinputs].str=NULL;
      }
    } else
      dontcut = 1;
  }
  if(dontcut && iinputs<MAX_INPUTS) {
    inputs[iinputs].nr=iinputs;
    inputs[iinputs].str=strdup("other");
    inputs[++iinputs].str=NULL;
  }
  encodings[xv_video_encodings_n].str = NULL;
  
  grab_xv.norms = norms;
  grab_xv.inputs = inputs;
  return 0;
}

static int
grab_close ()
{
  free_strtab(grab_xv.norms);
  free_strtab(grab_xv.inputs);
  free_strtab(encodings);
  grab_audio (1, -1, NULL);
  
  return 0;
}


/* this function must exist, but it is never executed
   (see x11.c/video_overlay() )*/
static int
grab_overlay (int x, int y, int width, int height, int format,
              struct OVERLAY_CLIP *oc, int count)
{
  return 0;
}

/* ---------------------------------------------------------------------- */

static int
grab_tune (unsigned long freq)
{
  xv_setfreq(freq);
  return 0;
}

static int
grab_tuned ()
{
  return xv_tuned();
}

static int
grab_input (int input, int norm)
{
  char *input_s,*norm_s,*encoding;
  int encoding_l,e;

  /*to make grab_input(input,-1); grab_input(-1,norm); work ! */
  static int input_def=-1,norm_def=-1;
  
  if(input==-1) input=input_def; else input_def=input;
  if(norm==-1) norm=norm_def; else norm_def=norm;
  input_s=int_to_str(input,grab_xv.inputs);
  if(input_s==NULL) return -1;
  norm_s=int_to_str(norm,grab_xv.norms);
  if(norm_s==NULL) return -1;
  encoding_l=strlen(input_s)+strlen(norm_s)+2;
  encoding=(char*)malloc(encoding_l);
  memset(encoding,0,encoding_l);
  strcat(encoding,norm_s);
  encoding[strlen(encoding)]=SEPARATOR;
  strcat(encoding,input_s);
  e=str_to_int(encoding,encodings);
  free(encoding);
  if(e==-1) e=str_to_int(norm_s,encodings);
  if(e==-1) return -1;
  xv_setencoding(e);
  return 0;
}

static int
grab_picture (int color, int bright, int hue, int contrast)
{
  xv_setpicture(color, bright, hue, contrast);
  return 0;
}

static int
grab_audio (int mute, int volume, int *mode)
{
  xv_setaudio(mute,volume);
  return 0;
}

static int is525(int norm) {
  char *cnorm = int_to_str(norm,grab_xv.norms);
  return strstr(cnorm,"ntsc") || strstr(cnorm,"NTSC") ||
    (strcasecmp(cnorm,"palm")==0) || (strcasecmp(cnorm,"pal60")==0);
}

static int issecam(int norm) {
  char *cnorm = int_to_str(norm,grab_xv.norms);
  return strstr(cnorm,"secam") || strstr(cnorm,"SECAM");
}

static void* get_buf(int i){
  return NULL;
}

struct GRABBER grab_xv = {
  "Xvideo TV-card driver",
  NULL, NULL,
  grab_open,
  grab_close,
  grab_overlay,
  NULL,
  NULL, 
  grab_tune,
  grab_tuned,
  grab_input,
  grab_picture,
  grab_audio,
  is525,
  issecam,
  get_buf
};


#endif // HAVE_VIDEO_XV
