/*****************************************************************************
 * grab_ui.c: GUI for the Grab parameters
 *****************************************************************************
 * $Id: grab_ui.c,v 1.3 2004/10/24 20:57:51 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2004 Pingus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <math.h>
#include <unistd.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#include "xdtv.h"
#include "grab.h"
#include "x11.h"
#include "file_sel.h"
#include "grab_ui.h"

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
# include "../pixmaps/grab_applysave.xpm"
# include "../pixmaps/grab_graboptions.xpm"
# include "../pixmaps/grab_grabimage.xpm"
# include "../pixmaps/grab_browse.xpm"
#endif
#endif

/*-------------------------------------------------------------------------*/
extern void save_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern Widget app_shell, c_graball;
extern Display *dpy;
extern Atom wm_protocols[2];
extern int debug;
extern char *filepath;
#ifdef HAVE_LIBJPEG
extern int jpegpcent;
#endif

static Widget grab_shell, grab_paned;
#ifdef HAVE_LIBJPEG
static Widget l_jpeg_pcent, s_jpeg_pcent;
#endif
static Widget c_grabquit, c_grablabel;
static Widget c_grabpath, c_grabpath_selector, c_grabfilepath;

#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif
/*------------------------------------------------------------------------*/

#define JPEG_RANGE          100.0

/*--------------------------------------------------------------------------*/

static void
close_grabwin (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  XtCallActionProc (grab_shell, "Grab", NULL, NULL, 0);
}

void
GrabAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;
  
  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Config: wm_save_yourself\n");
          XSetCommand (XtDisplay (grab_shell), XtWindow (grab_shell), NULL,
                       0);
          return;
        }
    }

  if (grab_shell == NULL)
    {
      fprintf(stderr, "GrabAction: ooops: grab_shell is NULL\n");
      return;
    }

  if (mapped)
    {
      XtPopdown (grab_shell);
      mapped = 0;
      if (c_graball)
        XtVaSetValues (c_graball, XtNlabel, "Grab an Image    :     (Off) (Ctrl+)G/J", NULL);
    }
  else
    {
      XtPopup (grab_shell, XtGrabNone);
      mapped = 1;
      if (c_graball)
        XtVaSetValues (c_graball, XtNlabel, "Grab an Image    : (Options)    Shift+G", NULL);  
      if (first)
        {
          XSetWMProtocols (XtDisplay (grab_shell), XtWindow (grab_shell),
                           wm_protocols, 2);
          first = 0;
        }
    }
}

/*--------------------------------------------------------------------------*/

static void
grab_jump_scb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  char *name;
  int value = 0;
  float data;  
  char label[64];

  data = *(float *) call_data;
  name = XtName (XtParent (widget));

#ifdef HAVE_LIBJPEG
  if (0 == strcmp(name, "jpeg_pcent"))
    {
      value = (int) rint(data * JPEG_RANGE);
      if (value == 0)
        value = 1;
      jpegpcent = value;

      if (s_jpeg_pcent)
        set_float (s_jpeg_pcent, XtNtopOfThumb, (float)value/JPEG_RANGE);

      sprintf(label, "%-" LABEL_WIDTH3 "s: %4d", "Jpeg Compression (in%)", value);       
      if (l_jpeg_pcent)
        XtVaSetValues(l_jpeg_pcent, XtNlabel, label, NULL);
      if (debug)
        fprintf(stderr,"Jpeg Compression (in%%): %4d\n",jpegpcent);
    }    
#endif
}

static void
grab_scroll_scb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  int move = (int) call_data;
  Dimension length;
  float shown, top1, top2;
  char *name;
  float step = 1.0;
  float range = 1.0;

  name = XtName (XtParent (widget));

  XtVaGetValues (widget,
                 XtNlength, &length,
                 XtNshown, &shown, XtNtopOfThumb, &top1, NULL);

#ifdef HAVE_LIBJPEG
 if (strcmp(name, "jpeg_pcent") == 0)
    {
      range = JPEG_RANGE;
      step = 1.0;
    } 
#endif

  if (move > 0)
    top2 = top1 + step/range;
  else
    top2 = top1 - step/range;
  if (top2 < 0.0)
    top2 = 0.0;
  if (top2 > 1.0)
    top2 = 1.0;

  grab_jump_scb (widget, clientdata, &top2);

}

/*-------------------------------------------------------------------------*/

// Code from mwxcd http://member.nifty.ne.jp/nmaruichi/
// the purpose is to have in Xaw a file selector to choose the path easily

static void srcSelectFinish(const char *dirName, const char *fileName)
{
	char Path[8192];
	if (fileName[0] != '\0')
	  sprintf(Path, "%s/%s", dirName, fileName);
	else
	  sprintf(Path, "%s", dirName);
	if(c_grabfilepath)
	  XtVaSetValues (c_grabfilepath, XtNstring, Path, NULL);
}


static void srcFileSelector(Widget w, XtPointer client_data, XtPointer call_data)
{
	char dirName[4096];
	char fileName[1024];
	extern selectorPanes filePickupPaneInfo[];
	extern selectorPanes fileSortPaneInfo[];
	static selectorPanes *defPickup = &filePickupPaneInfo[1];
	static selectorPanes *defSort = &fileSortPaneInfo[1];
	dirName[0] = '\0';
	fileName[0] = '\0';
	fileCheck(filepath, sizeof(dirName), dirName, sizeof(fileName), fileName);
	fileSelectorCall(w, dirName, defPickup, defSort, srcSelectFinish);
}

/*-------------------------------------------------------------------------*/


void
create_grabwin()
{
  Widget c,p;
  char label[64];

  grab_shell = XtVaAppCreateShell ("Grab", "Xawdecode",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell, XtNvisual,vinfo->visual,
				   XtNcolormap,colormap, XtNdepth,vinfo->depth,
				   NULL);

  grab_paned =
    XtVaCreateManagedWidget ("paned", panedWidgetClass, grab_shell, NULL);

  /* GrabLabel */
  c_grablabel = XtVaCreateManagedWidget ("lgrab", labelWidgetClass, grab_paned,
                           PANED_FIX, NULL); 
  
  
 /* Jpeg Compression */
#ifdef HAVE_LIBJPEG
  p = XtVaCreateManagedWidget ("jpeg_pcent", panedWidgetClass, grab_paned, XtNorientation, XtEvertical, PANED_FIX, NULL);
  l_jpeg_pcent = XtVaCreateManagedWidget ("lgrab_pcent", labelWidgetClass, p, XtNshowGrip, False, NULL);
  s_jpeg_pcent = XtVaCreateManagedWidget ("sgrab_pcent", scrollbarWidgetClass, p, PANED_FIX, NULL);
  set_float(s_jpeg_pcent, XtNtopOfThumb, (float)jpegpcent/JPEG_RANGE);
  sprintf (label, "%-" LABEL_WIDTH3 "s: %4d", "Jpeg Compression (in%)", jpegpcent);
  XtVaSetValues (l_jpeg_pcent, XtNlabel, label, NULL);  
  XtAddCallback (s_jpeg_pcent, XtNjumpProc, grab_jump_scb, NULL);
  XtAddCallback (s_jpeg_pcent, XtNscrollProc, grab_scroll_scb, NULL);
#endif
  
/* select the grab file path through a GUI */

  c_grabpath= c = XtVaCreateManagedWidget ("lgrabfilepath", labelWidgetClass, grab_paned,
                           PANED_FIX, NULL);  
  c_grabpath_selector = c = XtVaCreateManagedWidget ("lgrabfilepathselector", commandWidgetClass, grab_paned,
                               PANED_FIX, NULL);
  XtAddCallback(c, XtNcallback, srcFileSelector, NULL);  

      
/* Grab file path */

  c_grabfilepath = c = XtVaCreateManagedWidget ("grabfilepath", asciiTextWidgetClass, grab_paned,
                                                PANED_FIX, NULL);
  if (filepath == NULL) filepath = getcwd(NULL,0);

  XtVaSetValues (c_grabfilepath, XtNstring, filepath, NULL);
   
  
/* Button to close Grab Page Menu */

  c_grabquit = c = XtVaCreateManagedWidget ("lgrabclose", commandWidgetClass, grab_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, save_cb, (XtPointer) NULL);  
  XtAddCallback (c, XtNcallback, close_grabwin, (XtPointer) NULL);

#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(grab_shell),
                          RootWindowOfScreen(XtScreen(grab_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(grab_shell, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS
  XpmCreatePixmapFromData(XtDisplay(grab_paned),
                          RootWindowOfScreen(XtScreen(grab_paned)),
                          grab_applysave_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_grabquit, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(grab_paned),
                          RootWindowOfScreen(XtScreen(grab_paned)),
                          grab_graboptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_grablabel, XtNbitmap, icon_pixmap, NULL); 
  XpmCreatePixmapFromData(XtDisplay(grab_paned),
                          RootWindowOfScreen(XtScreen(grab_paned)),
                          grab_grabimage_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_grabpath, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(grab_paned),
                          RootWindowOfScreen(XtScreen(grab_paned)),
                          grab_browse_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_grabpath_selector, XtNbitmap, icon_pixmap, NULL);   
#endif
#endif  
  
}

void update_grabfilename(void)
{
  if(c_grabfilepath)
    XtVaGetValues (c_grabfilepath, XtNstring, &filepath, NULL);
}
