/*****************************************************************************
 * plugin_ui.c: GUI where all plugins UIs must be registered
 *****************************************************************************
 * $Id: plugin_ui.c,v 1.2 2004/09/29 08:10:41 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2004 Pingus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#include "xdtv.h"
#include "grab.h"
#include "x11.h"
#include "plugin_ui.h"

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
# include "../pixmaps/plugin_quit.xpm"
#endif
#endif

/*-------------------------------------------------------------------------*/
extern void save_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern Widget app_shell;
extern Display *dpy;
extern Atom wm_protocols[2];
extern int debug;

Widget plugin_paned;
static Widget plugin_shell, c_plugquit;


#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif

/*--------------------------------------------------------------------------*/

static void
close_pluginwin (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  XtCallActionProc (plugin_shell, "Plugin", NULL, NULL, 0);
}

void
PluginAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;
  
  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Config: wm_save_yourself\n");
          XSetCommand (XtDisplay (plugin_shell), XtWindow (plugin_shell), NULL,
                       0);
          return;
        }
    }

  if (plugin_shell == NULL)
    {
      fprintf(stderr, "PluginAction: ooops: plugin_shell is NULL\n");
      return;
    }

  if (mapped)
    {
      XtPopdown (plugin_shell);
      mapped = 0;
    }
  else
    {
      XtPopup (plugin_shell, XtGrabNone);
      mapped = 1;
      if (first)
        {
          XSetWMProtocols (XtDisplay (plugin_shell), XtWindow (plugin_shell),
                           wm_protocols, 2);
          first = 0;
        }
    }
}

/*--------------------------------------------------------------------------*/

void
create_pluginwin()
{
  Widget c;

  plugin_shell = XtVaAppCreateShell ("Plugin", "Xawdecode",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell, XtNvisual,vinfo->visual,
				   XtNcolormap,colormap, XtNdepth,vinfo->depth,
				   NULL);

  plugin_paned =
    XtVaCreateManagedWidget ("paned", panedWidgetClass, plugin_shell, NULL);

/* Button to close Plugin Page Menu */

  c_plugquit = c = XtVaCreateManagedWidget ("lplugclose", commandWidgetClass, plugin_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, close_pluginwin, (XtPointer) NULL);

#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(plugin_shell),
                          RootWindowOfScreen(XtScreen(plugin_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(plugin_shell, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS
  XpmCreatePixmapFromData(XtDisplay(plugin_paned),
                          RootWindowOfScreen(XtScreen(plugin_paned)),
                          plugin_quit_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_plugquit, XtNbitmap, icon_pixmap, NULL);   
    
#endif
#endif  
  
}
