/*****************************************************************************
 * messenger.c: to make xaw popup message error
 *****************************************************************************
 * $Id: stringuty.h,v 1.1 2004/03/25 21:30:08 pingus77 Exp $
 *****************************************************************************
 *
 * Adapted by Pingus 2004
 *
 *****************************************************************************
 *
 *	Copyright (C) 11996/05/16(Collected) -- 1996/05/18(First Fix)
 *                                  by Nobuyuki Maruichi
 *      From mwxcd 1.32
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 ***************************************************************************/

#ifndef	LINE_LINK_H
#define	LINE_LINK_H

#include <stdio.h>

#ifndef	NO_X_TOOLKIT
# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
#endif	/*NO_X_TOOLKIT*/

#define NumberOfArray(array) (sizeof(array)/sizeof(array[0]))

typedef struct _LineLink {
	char *string;
	struct _LineLink *next_ptr;
} LineLink;

typedef struct _PointorsLink {
	void *data_ptr;
	const char *type_pointer;
	size_t bufferSize;
	struct _PointorsLink *prevLink;
	struct _PointorsLink *nextLink;
	char typeName[1];
} PointorsLink;

int asciiStringCaseCmp(const char *s1, const char *s2);
LineLink *lineAlloc(const char *string);
void lineFree(LineLink *release_ptr);
void linesRelease(LineLink *lines);
LineLink *string2lines(const char *string);
LineLink *linesConnect(LineLink *lines1, LineLink *lines2);
int linesLength(LineLink *lines);
String lines2string(LineLink *lines);
int linesTextLength(LineLink *strings);
String lines4textString(LineLink *strings);
LineLink *file2lines(FILE *stream);
void lines2file(const LineLink *lines, FILE *stream);
int arrayCount(XtPointer *pointerArray);
void nullTerminatedPointerArrayFree(void **pointerArray);
int searchInStringArray(const char *target, int limit, const char **names,
							int (*compare)(const char *s1, const char *s2));
int searchInStringPointerArray(const char *target, const char **names,
							int (*compare)(const char *s1, const char *s2));
int VaCreatePointorsLink(PointorsLink **linkBuffer, ...);
int VaAddValuesLink(PointorsLink **linkTop, ...);
int VaGetPointorsLink(const PointorsLink *linkBuffer, ...);
void VaDestroyPointorsLink(PointorsLink *linkBuffer);
void *cutoffPointorsLink(PointorsLink **linkBuffer);
const void *prevPointersLink(const void *pointer);
const void *nextPointersLink(const void *pointer);
const void *numSearch(const void *client_data,
					int no, const void *(*nextStep)(const void *pointer));
int terminalCount(const void *client_data,
							const void *(*nextStep)(const void *pointer));
int VaCreateValuesLink(PointorsLink **linkBuffer, ...);
const void *terminalSearch(const void *client_data,
							const void *(*nextStep)(const void *pointer));
int VaGetValuesLink(const PointorsLink *linkBuffer, ...);
int VaGetAbsValuesLink(const PointorsLink *linkBuffer, int step, ...);
int VaGetRelValuesLink(const PointorsLink *linkBuffer, int step, ...);

#endif	/*LINE_LINK_H*/

