/*****************************************************************************
 * subtitles_ui.c: Enter your own subtitle page
 *****************************************************************************
 * $Id: subtitles_ui.c,v 1.19 2004/10/12 22:25:26 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2004 Pingus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/AsciiText.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#include "xdtv.h"
#include "grab.h"
#include "x11.h"

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
# include "../pixmaps/sub_pagenum.xpm"
# include "../pixmaps/sub_openmainoptions.xpm"
# include "../pixmaps/sub_applysave.xpm"
# include "../pixmaps/sub_startsub.xpm"
#endif
#endif

# include "popup_ui.h"
# include "channel.h"

/*-------------------------------------------------------------------------*/
extern void save_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern void ToggleSubAction (Widget, XEvent *, String *, Cardinal *);
extern void OptionsAction (Widget, XEvent *, String *, Cardinal *);
extern void action_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern Widget app_shell, c_subpageno;
extern Display *dpy;
extern Atom wm_protocols[2];
extern int debug;
extern char title[256];
extern int subactive;
extern int xawpopup;
extern int set_subpage(char *name);

static Widget subpage_shell, subpage_paned;
static Widget c_subpagenum;
static Widget c_subtitles;
static Widget c_openmain;
static Widget c_save;

Widget t_subpagenum;

#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif

/*-------------------------------------------------------------------------*/

struct CALL_ACTION call_subtitles = { 0, "ToggleSub", {NULL} };
struct CALL_ACTION call_options_3 = { 0, "Options", {NULL} };

/*--------------------------------------------------------------------------*/

static void
close_subpagewin (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  XtCallActionProc (subpage_shell, "SubPage", NULL, NULL, 0);
}

static void update_subpagenum (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  char *s;

  // on rcupre ce qui a t crit par l'utilisateur
  XtVaGetValues (t_subpagenum, XtNstring, &s, NULL);

  set_subpage(strdup(s));
}


void
SubPageAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;
  if (debug)
  fprintf(stderr,"Current Subtitles Page SubPageAction: %s\n",cur_subpage);

  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Config: wm_save_yourself\n");
          XSetCommand (XtDisplay (subpage_shell), XtWindow (subpage_shell), NULL,
                       0);
          return;
        }
    }

  if (subpage_shell == NULL)
    {
      fprintf(stderr, "SubPageAction: ooops: subpage_shell is NULL\n");
            if (xawpopup)
              PopupMessage("SubPageAction:\nooops: subpage_shell is NULL\n");
      return;
    }

  if (mapped)
    {
      XtPopdown (subpage_shell);
      mapped = 0;
    }
  else
    {
      XtPopup (subpage_shell, XtGrabNone);
      mapped = 1;
      if (first)
        {
          XSetWMProtocols (XtDisplay (subpage_shell), XtWindow (subpage_shell),
                           wm_protocols, 2);
          first = 0;
        }
    }
}

/*--------------------------------------------------------------------------*/

void
create_subpagewin()
{
  Widget c;

  subpage_shell = XtVaAppCreateShell ("SubPage", "XdTV",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell, XtNvisual,vinfo->visual,
				   XtNcolormap,colormap, XtNdepth,vinfo->depth,
				   NULL);

  subpage_paned =
    XtVaCreateManagedWidget ("paned", panedWidgetClass, subpage_shell, NULL);

  /* Subtitle page number */

  c_subpagenum = c = XtVaCreateManagedWidget ("lsubpagenum", labelWidgetClass, subpage_paned,
                           PANED_FIX, NULL);
  t_subpagenum = c = XtVaCreateManagedWidget ("subpagenum", asciiTextWidgetClass, subpage_paned,
                                                PANED_FIX, NULL);

  
/* launch Subtitles Action */
  c_subtitles = c = XtVaCreateManagedWidget ("lsubtitles", commandWidgetClass, subpage_paned, PANED_FIX, NULL);
    XtAddCallback (c, XtNcallback, close_subpagewin, (XtPointer) NULL);   
    XtAddCallback (c, XtNcallback, action_cb, (XtPointer) & call_subtitles);   

    
/* Open Main Options Menu */
  c_openmain = c = XtVaCreateManagedWidget ("lopenmain", commandWidgetClass, subpage_paned, PANED_FIX, NULL);
    XtAddCallback (c, XtNcallback, action_cb, (XtPointer) & call_options_3);
          

/* Button to close Subtitle Page Menu */

  c_save = XtVaCreateManagedWidget ("lsubsave", commandWidgetClass, subpage_paned, PANED_FIX, NULL);
  
  // on met  jour l'info, on sauvegarde puis on quitte la GUI
  XtAddCallback (c_save, XtNcallback, update_subpagenum, (XtPointer) NULL);
  XtAddCallback (c_save, XtNcallback, save_cb, (XtPointer) NULL);
  XtAddCallback (c_save, XtNcallback, close_subpagewin, (XtPointer) NULL);

#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(subpage_shell),
                          RootWindowOfScreen(XtScreen(subpage_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(subpage_shell, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS
  XpmCreatePixmapFromData(XtDisplay(subpage_paned),
                          RootWindowOfScreen(XtScreen(subpage_paned)),
                          sub_pagenum_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_subpagenum, XtNbitmap, icon_pixmap, NULL);   
  
  XpmCreatePixmapFromData(XtDisplay(subpage_paned),
                          RootWindowOfScreen(XtScreen(subpage_paned)),
                          sub_openmainoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_openmain, XtNbitmap, icon_pixmap, NULL);    
  
  XpmCreatePixmapFromData(XtDisplay(subpage_paned),
                          RootWindowOfScreen(XtScreen(subpage_paned)),
                          sub_applysave_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_save, XtNbitmap, icon_pixmap, NULL);
  
  XpmCreatePixmapFromData(XtDisplay(subpage_paned),
                          RootWindowOfScreen(XtScreen(subpage_paned)),
                          sub_startsub_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_subtitles, XtNbitmap, icon_pixmap, NULL);   
#endif
#endif

}
