/*****************************************************************************
 * $Id: vop-deint-onefield.c,v 1.1 2004/09/18 16:46:55 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 * Deinterlace routines for xine by Miguel Freitas
 * based of DScaler project sources (deinterlace.sourceforge.net)
 *****************************************************************************/
#include <stdio.h>
#include "config.h"

#ifdef ARCH_X86

#include "colorspace.h"
#include "vop.h"
#include "memcpy.h"
#include "cpu_accel.h"
extern int debug;

static int deinterlace_onefield_yuv_mmx(vop2 *v,  unsigned char *dest, unsigned char *src, 
				   int width, int height) {
  int Line;
  uint64_t *YVal1;
  uint64_t *YVal3;
  uint64_t *Dest;
  uint8_t* pEvenLines = src;
  uint8_t* pOddLines = src+2*width;
  int LineLength = width * 2;
  int SourcePitch = width * 4;
  int IsOdd = 1;

  int n;

  static mmx_t Mask = {ub:{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}};

  /*
   * copy first even line no matter what, and the first odd line if we're
   * processing an odd field.
   */

  fast_memcpy(dest, pEvenLines, LineLength);
  if (IsOdd)
    fast_memcpy(dest + LineLength, pOddLines, LineLength);

  height = height / 2;
  for (Line = 0; Line < height - 1; ++Line)
  {
    if (IsOdd)
    {
      YVal1 = (uint64_t *)(pOddLines + Line * SourcePitch);
      YVal3 = (uint64_t *)(pOddLines + (Line + 1) * SourcePitch);
      Dest = (uint64_t *)(dest + (Line * 2 + 2) * LineLength);
    }
    else
    {
      YVal1 = (uint64_t *)(pEvenLines + Line * SourcePitch);
      YVal3 = (uint64_t *)(pEvenLines + (Line + 1) * SourcePitch);
      Dest = (uint64_t *)(dest + (Line * 2 + 1) * LineLength);
    }

    // Copy the odd line to the overlay verbatim.
    fast_memcpy((char *)Dest + LineLength, YVal3, LineLength);

    n = LineLength >> 3;
    while( n-- )
    {
      movq_m2r (*YVal1++, mm0);
      movq_m2r (*YVal3++, mm2);

      // get average in mm0
      pand_m2r ( Mask, mm0 );
      pand_m2r ( Mask, mm2 );
      psrlw_i2r ( 01, mm0 );
      psrlw_i2r ( 01, mm2 );
      paddw_r2r ( mm2, mm0 );

      movq_r2m ( mm0, *Dest++ );
    }
  }

  /* Copy last odd line if we're processing an even field. */
  if (! IsOdd)
  {
    fast_memcpy(dest + (height * 2 - 1) * LineLength,
                      pOddLines + (height - 1) * SourcePitch,
                      LineLength);
  }

  /* clear out the MMX registers ready for doing floating point
   * again
   */
  emms();
  return 1;
}

vop vop_deint_onefield = {
  "deintonefield",  /* name */
  1,           /* only 1 image is needed */
  VIDEO_YUYV,  /* input format  */
  VIDEO_YUYV,  /* output format */
  deinterlace_onefield_yuv_mmx,  /* The TREATMENT function */
  NULL,        /* No reinitialization function */
  0,           /* the width of the input is equal to the output width*/
  0,           /* idem for the height */
  -1,          /* the destination height is 480 for ntsc, 576 for ntsc */
  1            /* preferably the last treatment */
};

#endif

