/*****************************************************************************
 * $Id: vop-test.c,v 1.10 2004/09/19 15:55:49 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

/* simple VOP test operations to test the VOP
   interface */
#include <stdio.h>
#include "config.h"
#include "colorspace.h"
#include "vop.h"
#include "memcpy.h"

/********* VOP COPY ***************************************/
static int treat_copy(vop2 *v, unsigned char *dest, unsigned char *src, int w, int h) {
  if(debug>1) fprintf(stderr, "treat_copy %p %p\n", dest, src);
  fast_memcpy(dest, src, size_img(VIDEO_YUYV,w,h));
  return 1;
}

vop vop_copy = {
  "copy",      /* name */
  1,           /* only 1 image is needed */
  VIDEO_YUYV,  /* input format  */
  VIDEO_YUYV,  /* output format */
  treat_copy,  /* The TREATMENT function */
  NULL,        /* No reinitialization function */
  0,           /* the width of the input is equal to the output width*/
  0,           /* idem for the height */
  0,           /* no constraint for the destination height */
  0            /* it preferably the first filter in the treatment */
};

/********* END VOP COPY **************************************/

/* to test with xdtv -vop copyb -grabfmt gray8 */
static int treat_copy_b(vop2 *v, unsigned char *dest, unsigned char *src, int w, int h) {
  if(debug>1) fprintf(stderr, "treat_copy_b %p %p\n", dest, src);
  fast_memcpy(dest, src+size_img(VIDEO_YUYV,w,cur_maxheight-h),
	      size_img(VIDEO_YUYV,w,h));
  return 1;
}
vop vop_copy_b = {
  "copyb",
  2,
  VIDEO_YUYV,
  VIDEO_YUYV,
  treat_copy_b,
  NULL,
  0,
  -1, /* 576 in pal and 480 in secam */
  0,
  1  /* preferably the last filter in the treatment */
};

/********* VOP HALF_LATE ********************************/

static int treat_half_late(vop2 *v, unsigned char *dest, unsigned char *src, int w, int h) {
  int l;
  if(debug>1) fprintf(stderr, "treat_half_top %p %p\n", dest, src);
  l=size_img(VIDEO_YUYV,w,h)/2;
  fast_memcpy(dest, v->bufs[(v->buf_cur+v->nbufs-10)%v->nbufs], l);
  fast_memcpy(dest+l, src+l, l);
  return 1;
}

vop vop_halflate = {
  "halflate",
  11,
  VIDEO_YUYV,
  VIDEO_YUYV,
  treat_half_late,
  NULL,
  0,
  0,
  0,
  1  /* post-filter */
};

/***** VOP MONOCHROME, just for the fun, try with -grabfmt hi240 */
static int treat_monoc(vop2 *v, unsigned char *dest, unsigned char *src, int w, int h) {
  if(debug>1) fprintf(stderr, "treat_monoc %p %p\n", dest, src);
  fast_memcpy(dest, src, size_img(VIDEO_GRAY1,w,h));
  return 1;
}

vop vop_monoc = {
  "monochrome",
  1,
  VIDEO_GRAY1,
  VIDEO_GRAY1,
  treat_monoc,
  NULL,
  0,
  0,
  0,
  0  /* pre-filter */
};
