require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_CPUFUNC_H_)) {
    eval 'sub _ARM_CPUFUNC_H_ () {1;}' unless defined(&_ARM_CPUFUNC_H_);
    if(defined(&_KERNEL)) {
	require 'sys/types.ph';
	require 'arm/cpuconf.ph';
	eval 'sub cpu_id () {
	    eval q( ($cpufuncs->{cf_id})());
	}' unless defined(&cpu_id);
	eval 'sub cpu_cpwait () {
	    eval q( ($cpufuncs->{cf_cpwait})());
	}' unless defined(&cpu_cpwait);
	eval 'sub cpu_control {
	    my($c, $s) = @_;
    	    eval q( ($cpufuncs->{cf_control})($c, $s));
	}' unless defined(&cpu_control);
	eval 'sub cpu_auxcontrol {
	    my($c, $s) = @_;
    	    eval q( ($cpufuncs->{cf_auxcontrol})($c, $s));
	}' unless defined(&cpu_auxcontrol);
	eval 'sub cpu_domains {
	    my($d) = @_;
    	    eval q( ($cpufuncs->{cf_domains})($d));
	}' unless defined(&cpu_domains);
	eval 'sub cpu_setttb {
	    my($t) = @_;
    	    eval q( ($cpufuncs->{cf_setttb})($t));
	}' unless defined(&cpu_setttb);
	eval 'sub cpu_dfsr () {
	    eval q( ($cpufuncs->{cf_dfsr})());
	}' unless defined(&cpu_dfsr);
	eval 'sub cpu_dfar () {
	    eval q( ($cpufuncs->{cf_dfar})());
	}' unless defined(&cpu_dfar);
	eval 'sub cpu_ifsr () {
	    eval q( ($cpufuncs->{cf_ifsr})());
	}' unless defined(&cpu_ifsr);
	eval 'sub cpu_ifar () {
	    eval q( ($cpufuncs->{cf_ifar})());
	}' unless defined(&cpu_ifar);
	eval 'sub cpu_tlb_flushID () {
	    eval q( ($cpufuncs->{cf_tlb_flushID})());
	}' unless defined(&cpu_tlb_flushID);
	eval 'sub cpu_tlb_flushID_SE {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_tlb_flushID_SE})($e));
	}' unless defined(&cpu_tlb_flushID_SE);
	eval 'sub cpu_tlb_flushI () {
	    eval q( ($cpufuncs->{cf_tlb_flushI})());
	}' unless defined(&cpu_tlb_flushI);
	eval 'sub cpu_tlb_flushI_SE {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_tlb_flushI_SE})($e));
	}' unless defined(&cpu_tlb_flushI_SE);
	eval 'sub cpu_tlb_flushD () {
	    eval q( ($cpufuncs->{cf_tlb_flushD})());
	}' unless defined(&cpu_tlb_flushD);
	eval 'sub cpu_tlb_flushD_SE {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_tlb_flushD_SE})($e));
	}' unless defined(&cpu_tlb_flushD_SE);
	eval 'sub cpu_icache_sync_all () {
	    eval q( ($cpufuncs->{cf_icache_sync_all})());
	}' unless defined(&cpu_icache_sync_all);
	eval 'sub cpu_icache_sync_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_icache_sync_range})(($a), ($s)));
	}' unless defined(&cpu_icache_sync_range);
	eval 'sub cpu_dcache_wbinv_all () {
	    eval q( ($cpufuncs->{cf_dcache_wbinv_all})());
	}' unless defined(&cpu_dcache_wbinv_all);
	eval 'sub cpu_dcache_wbinv_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_dcache_wbinv_range})(($a), ($s)));
	}' unless defined(&cpu_dcache_wbinv_range);
	eval 'sub cpu_dcache_inv_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_dcache_inv_range})(($a), ($s)));
	}' unless defined(&cpu_dcache_inv_range);
	eval 'sub cpu_dcache_wb_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_dcache_wb_range})(($a), ($s)));
	}' unless defined(&cpu_dcache_wb_range);
	eval 'sub cpu_idcache_wbinv_all () {
	    eval q( ($cpufuncs->{cf_idcache_wbinv_all})());
	}' unless defined(&cpu_idcache_wbinv_all);
	eval 'sub cpu_idcache_wbinv_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_idcache_wbinv_range})(($a), ($s)));
	}' unless defined(&cpu_idcache_wbinv_range);
	eval 'sub cpu_sdcache_enabled () {
	    eval q(( ($cpufuncs->{cf_sdcache_wbinv_all}) !=  &cpufunc_nullop));
	}' unless defined(&cpu_sdcache_enabled);
	eval 'sub cpu_sdcache_wbinv_all () {
	    eval q( ($cpufuncs->{cf_sdcache_wbinv_all})());
	}' unless defined(&cpu_sdcache_wbinv_all);
	eval 'sub cpu_sdcache_wbinv_range {
	    my($va, $pa, $s) = @_;
    	    eval q( ($cpufuncs->{cf_sdcache_wbinv_range})(($va), ($pa), ($s)));
	}' unless defined(&cpu_sdcache_wbinv_range);
	eval 'sub cpu_sdcache_inv_range {
	    my($va, $pa, $s) = @_;
    	    eval q( ($cpufuncs->{cf_sdcache_inv_range})(($va), ($pa), ($s)));
	}' unless defined(&cpu_sdcache_inv_range);
	eval 'sub cpu_sdcache_wb_range {
	    my($va, $pa, $s) = @_;
    	    eval q( ($cpufuncs->{cf_sdcache_wb_range})(($va), ($pa), ($s)));
	}' unless defined(&cpu_sdcache_wb_range);
	eval 'sub cpu_flush_prefetchbuf () {
	    eval q( ($cpufuncs->{cf_flush_prefetchbuf})());
	}' unless defined(&cpu_flush_prefetchbuf);
	eval 'sub cpu_drain_writebuf () {
	    eval q( ($cpufuncs->{cf_drain_writebuf})());
	}' unless defined(&cpu_drain_writebuf);
	eval 'sub cpu_sleep {
	    my($m) = @_;
    	    eval q( ($cpufuncs->{cf_sleep})($m));
	}' unless defined(&cpu_sleep);
	eval 'sub cpu_context_switch {
	    my($a) = @_;
    	    eval q( ($cpufuncs->{cf_context_switch})($a));
	}' unless defined(&cpu_context_switch);
	eval 'sub cpu_setup {
	    my($a) = @_;
    	    eval q( ($cpufuncs->{cf_setup})($a));
	}' unless defined(&cpu_setup);
	eval 'sub ARCHITECTURE_NOT_PRESENT () {1;}' unless defined(&ARCHITECTURE_NOT_PRESENT);
	eval 'sub ARCHITECTURE_NOT_SUPPORTED () {2;}' unless defined(&ARCHITECTURE_NOT_SUPPORTED);
	if(defined(&CPU_ARMv7)) {
	}
	if(defined(&CPU_XSCALE_80321) || defined(&CPU_XSCALE_PXA2X0)) {
	}
	if(defined(&CPU_XSCALE_80321) || defined(&CPU_XSCALE_PXA2X0) || ((defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : undef) == 1)) {
	}
	eval 'sub tlb_flush () { &cpu_tlb_flushID;}' unless defined(&tlb_flush);
	eval 'sub setttb () { &cpu_setttb;}' unless defined(&setttb);
	eval 'sub drain_writebuf () { &cpu_drain_writebuf;}' unless defined(&drain_writebuf);
	eval 'sub __set_cpsr_c {
	    my($bic,$eor) = @_;
    	    eval q({  &u_int32_t  &tmp,  &ret;  &__asm  &volatile( \\"mrs	%0, cpsr\\\\n\\\\t\\" \\"bic	%1, %0, %2\\\\n\\\\t\\" \\"eor	%1, %1, %3\\\\n\\\\t\\" \\"msr	cpsr_c, %1\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &tmp) : \\"r\\" ($bic), \\"r\\" ($eor));  &ret; });
	}' unless defined(&__set_cpsr_c);
	eval 'sub __get_cpsr () {
	    eval q({  &u_int32_t  &ret;  &__asm  &volatile(\\"mrs	%0, cpsr\\" : \\"=&r\\" ( &ret));  &ret; });
	}' unless defined(&__get_cpsr);
	eval 'sub disable_interrupts {
	    my($mask) = @_;
    	    eval q(( &__set_cpsr_c(($mask) & ( &PSR_I |  &PSR_F), ($mask) & ( &PSR_I |  &PSR_F))));
	}' unless defined(&disable_interrupts);
	eval 'sub enable_interrupts {
	    my($mask) = @_;
    	    eval q(( &__set_cpsr_c(($mask) & ( &PSR_I |  &PSR_F), 0)));
	}' unless defined(&enable_interrupts);
	eval 'sub restore_interrupts {
	    my($old_cpsr) = @_;
    	    eval q(( &__set_cpsr_c(( &PSR_I |  &PSR_F), ($old_cpsr) & ( &PSR_I |  &PSR_F))));
	}' unless defined(&restore_interrupts);
    }
}
1;
