require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS64_DB_MACHDEP_H_)) {
    eval 'sub _MIPS64_DB_MACHDEP_H_ () {1;}' unless defined(&_MIPS64_DB_MACHDEP_H_);
    require 'machine/frame.ph';
    require 'machine/trap.ph';
    require 'uvm/uvm_param.ph';
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub SOFTWARE_SSTEP () {1;}' unless defined(&SOFTWARE_SSTEP);
    eval 'sub SOFTWARE_SSTEP_EMUL () {1;}' unless defined(&SOFTWARE_SSTEP_EMUL);
    eval 'sub BKPT_SIZE () {(4);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($ins) = @_;
	    eval q(( &BREAK_DDB));
    }' unless defined(&BKPT_SET);
    eval 'sub DB_VALID_BREAKPOINT {
        my($addr) = @_;
	    eval q(((($addr) & 3) == 0));
    }' unless defined(&DB_VALID_BREAKPOINT);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BREAK));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((0));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &pc));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q(($regs)-> &pc = ( &register_t)($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub inst_branch {
        my($i) = @_;
	    eval q(( &classify_insn($i) ==  &INSNCLASS_BRANCH));
    }' unless defined(&inst_branch);
    eval 'sub inst_trap_return {
        my($i) = @_;
	    eval q((($i) & 0));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_call {
        my($i) = @_;
	    eval q(( &classify_insn($i) ==  &INSNCLASS_CALL));
    }' unless defined(&inst_call);
    eval 'sub inst_return {
        my($i) = @_;
	    eval q((($i) == 0x3e00008));
    }' unless defined(&inst_return);
    eval 'sub DDB_STATE_NOT_RUNNING () {0;}' unless defined(&DDB_STATE_NOT_RUNNING);
    eval 'sub DDB_STATE_RUNNING () {1;}' unless defined(&DDB_STATE_RUNNING);
    eval 'sub DDB_STATE_EXITING () {2;}' unless defined(&DDB_STATE_EXITING);
}
1;
